/**
 * 
 * <p>CConsultHarpege</p>
 * <p>Description : Consultation du dossier personnel d'HARPEGE</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-Marc GULLUNG</a>
 * @version 1.0
 *
 */
package org.esupportail.portal.channels.gestion.CConsultHarpege;

import java.sql.SQLException;
import org.apache.log4j.Priority;
import org.esupportail.portal.channels.gestion.CConsultHarpege.Config;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.connectors_harpege.HarpegeConnector;
import org.esupportail.portal.utils.connectors_harpege.ConnectorException;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;
import org.esupportail.portal.utils.channels.plugins.FatalError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CConsultHarpege extends MainChannel {

	protected static final Log log = LogFactory.getLog(CConsultHarpege.class);

	// id de l'utilisateur
	private String userId;
	// no_individu de l'individu
	protected String no_individu;
	// flux xml correspondant  l'en-tte des diffrentes pages
	private String xmlIndividu;

	public CConsultHarpege() throws PortalException {
		setConfigActions(Config.getInstance());	
	}

	/** 
	 *  Receive static channel data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelStaticData</b> sd static channel data
	 * @throws PortalException
	 */
	public void setStaticData(ChannelStaticData sd) throws PortalException {
		super.setStaticData(sd);
		userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		no_individu = getNoIndividu();
	}

	/**
	 * Rcupration du no_individu de l'agent
	 *
	 */
	public String getNoIndividu() {

		if (no_individu == null) {

			// on rcupre le no_individu via le connecteur Harpege
			try {
				no_individu = HarpegeConnector.getNO_INDIVIDU(getStaticData().getPerson());
			} 
			catch (ConnectorException e1) {
				// enregistrement plugin fatalError
				FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
				return null;
			}
		}

		return no_individu;
	}

	/**
	 * Mthode qui retourne les infos principales de l'agent sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlIndividu() throws FrameWorkException {
		Query qry = null;
		boolean error = false;
		StringBuffer res = null;
//		no_individu="5201";
		if (xmlIndividu == null) {
			res = new StringBuffer("<individu>");
			//	Connexion  la base et excution d'une requte

			try {
				no_individu = getNoIndividu();
				if (no_individu != null) { // la personne connecte  un no_individu
					qry = Config.getInstance().getConnexionDefault();
					qry.setSql("select no_individu,c_civilite,nom_usuel,nom_patronymique,prenom from individu where no_individu = ? ");
					qry.getStmt().setString(1, no_individu);
					qry.select();			   
					while (qry.getRs().next()){
						res.append("<dossier>").
						append(qry.getRs().getString("no_individu")).
						append("</dossier>");
						res.append("<nom_usuel>").
						append(qry.getRs().getString("nom_usuel")).
						append("</nom_usuel>");
						res.append("<nom_patro>").
						append(qry.getRs().getString("nom_patronymique")).
						append("</nom_patro>");
						res.append("<prenom>").
						append(qry.getRs().getString("prenom")).
						append("</prenom>");
						res.append("<civilite>").
						append(qry.getRs().getString("c_civilite")).
						append("</civilite>");
					}
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("CConsultHarpege::getXmlIndividu() : Erreur SQL " + e);
		        }
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("CConsultHarpege::getXmlIndividu() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}

			res.append("</individu>");
		}
		return res;
	}

	/**
	 * Mthode qui permet de positionner no_individu  une valeur autre que celle de l'individu 
	 * 
	 */
	public void setNoIndividu(String no_ind) {
		no_individu=no_ind;
	}
}
