<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:import href="genIndividu.xsl"/>
    <xsl:import href="Liens.xsl"/>
    <xsl:output indent="no" method="html"/>
    <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>
    <xsl:param name="prefForm"/>
    <xsl:param name="modeServant">none</xsl:param>
    <xsl:param name="mediaPath"/>
    <xsl:template match="/">
        <xsl:call-template name="genIndividu">
            <xsl:with-param name="civilite" select="xml/individu/civilite"/>
            <xsl:with-param name="dossier" select="xml/individu/dossier"/>
            <xsl:with-param name="nom_patro" select="xml/individu/nom_patro"/>
            <xsl:with-param name="nom_usuel" select="xml/individu/nom_usuel"/>
            <xsl:with-param name="prenom" select="xml/individu/prenom"/>
        </xsl:call-template>
        <xsl:call-template name="liensHorizontaux">
            <xsl:with-param name="annuaire" select="$modeServant"/>
        </xsl:call-template>
        <div class="navigation-selected">
            <P ALIGN="CENTER" class="uportal-background-dark">
                <br/>
                <b>P O S I T I O N - A G E N T</b>
                <br/>
                <br/>
            </P>
        </div>
	   <xsl:if test="count(xml/positions/position) = 0 and count(xml/tempspartiels/tempspartiel) = 0 and count(xml/bonifications/bonification) = 0 and count(xml/services/service) = 0 and count(xml/notes/note) = 0">
	        <p class="uportal-channel-strong" align="center">Pas d'information sur l'agent.</p>
	   </xsl:if>
        <xsl:apply-templates select="xml/positions"/>
        <xsl:apply-templates select="xml/tempspartiels"/>
        <xsl:apply-templates select="xml/bonifications"/>
        <xsl:apply-templates select="xml/services"/>
        <xsl:apply-templates select="xml/notes"/>
    </xsl:template>

    <xsl:template match="positions">
        <xsl:if test="count(position) != 0">
	            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	                <TR class="uportal-background-light">
	                    <TD HEIGHT="30">
	                        <P ALIGN="LEFT" class="uportal-channel-strong">Positions</P>
	                    </TD>
	                </TR>
	            </TABLE>
	            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
		                <TR>
		                    <TD WIDTH="30%" class="uportal-channel-strong">Libellé</TD>
		                    <TD WIDTH="30%" class="uportal-channel-strong">Motif</TD>
		                    <TD WIDTH="40%" class="uportal-channel-strong">Date début</TD>
		                </TR>
		                <xsl:apply-templates select="position"/>
		            </TABLE>
        </xsl:if>
    </xsl:template>

    <xsl:template match="position">
	        <TR>
	            <TD WIDTH="30%" class="uportal-text">
                <xsl:value-of select="lib_position"/>
            </TD>
	            <TD WIDTH="30%" class="uportal-text">
					<xsl:if test="motif_position != 'null'">
                <xsl:value-of select="motif_position"/>
					</xsl:if>
            </TD>
	            <TD WIDTH="40%" class="uportal-text">
                <xsl:value-of select="date_position"/>
            </TD>
	        </TR>
    </xsl:template>

    <xsl:template match="tempspartiels">
        <xsl:if test="count(tempspartiel) != 0">
            <BR/>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
                <TR class="uportal-background-light">
                    <TD HEIGHT="30">
                        <P ALIGN="LEFT" class="uportal-channel-strong">Temps partiels</P>
                    </TD>
                </TR>
            </TABLE>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	                <TR>
	                    <TD WIDTH="25%" class="uportal-channel-strong">Période</TD>
	                    <TD WIDTH="25%" class="uportal-channel-strong">Date fin réelle</TD>
	                    <TD WIDTH="25%" class="uportal-channel-strong">Quotité</TD>
	                </TR>
	                <xsl:apply-templates select="tempspartiel"/>
	            </TABLE>
        </xsl:if>
    </xsl:template>

    <xsl:template match="tempspartiel">
	        <TR>
		 <xsl:if test="position() mod 2 = 1">
		   <xsl:attribute name="class">uportal-background-highlight</xsl:attribute>
		 </xsl:if>
		 <xsl:if test="position() mod 2 = 0">
		   <xsl:attribute name="class">uportal-background-content</xsl:attribute>
		 </xsl:if>
	        <TD WIDTH="25%" class="uportal-text">
                Du <xsl:value-of select="date_debut" /> au <xsl:value-of select="date_fin" />
            </TD>
	        <TD WIDTH="25%" class="uportal-text">
				<xsl:if test="date_fin_reelle != 'null'">
	                <xsl:value-of select="date_fin_reelle"/>
				</xsl:if>
            </TD>
	        <TD WIDTH="25%" class="uportal-text">
                <xsl:value-of select="quotite"/>
            </TD>
	        </TR>
    </xsl:template>

    <xsl:template match="bonifications">
        <xsl:if test="count(bonification) != 0">
            <BR/>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
                <TR class="uportal-background-light">
                    <TD HEIGHT="30">
                        <P ALIGN="LEFT" class="uportal-channel-strong">Bonifications indiciaires</P>
                    </TD>
                </TR>
            </TABLE>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	                <TR>
	                    <TD WIDTH="30%" class="uportal-channel-strong">Libellé</TD>
	                    <TD WIDTH="30%" class="uportal-channel-strong">Points</TD>
	                    <TD WIDTH="40%" class="uportal-channel-strong">Date début</TD>
	                </TR>
	                <xsl:apply-templates select="bonification"/>
	            </TABLE>
        </xsl:if>
    </xsl:template>

    <xsl:template match="bonification">
	        <TR>
	            <TD WIDTH="30%" class="uportal-text">
                <xsl:value-of select="bonification_libelle"/>
            </TD>
	            <TD WIDTH="30%" class="uportal-text">
                <xsl:value-of select="bonification_point"/>
            </TD>
	            <TD WIDTH="40%" class="uportal-text">
                <xsl:value-of select="bonification_date"/>
            </TD>
	        </TR>
    </xsl:template>

    <xsl:template match="services">
        <xsl:if test="count(service) != 0">
            <BR/>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
                <TR class="uportal-background-light">
                    <TD HEIGHT="30">
                        <P ALIGN="LEFT" class="uportal-channel-strong">Services Hors Education Nationale</P>
                    </TD>
                </TR>
            </TABLE>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	                <TR>
	                    <TD WIDTH="25%" class="uportal-channel-strong">Période</TD>
	                    <TD WIDTH="25%" class="uportal-channel-strong">Etablissement / Entreprise</TD>
	                    <TD WIDTH="25%" class="uportal-channel-strong">Fonctions / Corps</TD>
	                    <TD WIDTH="25%" class="uportal-channel-strong">Durée</TD>
	                </TR>
	                <xsl:apply-templates select="service"/>
	            </TABLE>
        </xsl:if>
    </xsl:template>

    <xsl:template match="service">
	        <TR>
            <TD WIDTH="25%" class="uportal-text">
                <xsl:value-of select="periode"/>
            </TD>
            <TD WIDTH="25%" class="uportal-text">
                <xsl:value-of select="etablissement"/>
            </TD>
            <TD WIDTH="25%" class="uportal-text">
                <xsl:value-of select="fonction"/>
            </TD>
            <TD WIDTH="25%" class="uportal-text">
				<xsl:if test="duree_annee != ''">
					<xsl:value-of select="duree_annee"/> année 
            </xsl:if>
            <xsl:if test="duree_mois != ''">
                <xsl:value-of select="duree_mois"/> mois
            </xsl:if>
            </TD>
	        </TR>
    </xsl:template>

    <xsl:template match="notes">
        <xsl:if test="count(note) != 0">
            <BR/>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
                <TR class="uportal-background-light">
                    <TD HEIGHT="30">
                        <P ALIGN="LEFT" class="uportal-channel-strong">Notes</P>
                    </TD>
                </TR>
            </TABLE>
            <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	                <TR>
	                    <TD WIDTH="30%" class="uportal-channel-strong">Année</TD>
	                    <TD WIDTH="30%" class="uportal-channel-strong">Grade</TD>
	                    <TD WIDTH="20%" class="uportal-channel-strong">Note proposée</TD>
	                    <TD WIDTH="20%" class="uportal-channel-strong">Note définitive</TD>
	                </TR>
	                <xsl:apply-templates select="note"/>
	            </TABLE>
        </xsl:if>
    </xsl:template>

    <xsl:template match="note">
	        <TR>
		 <xsl:if test="position() mod 2 = 0">
		   <xsl:attribute name="class">uportal-background-highlight</xsl:attribute>
		 </xsl:if>
		 <xsl:if test="position() mod 2 = 1">
		   <xsl:attribute name="class">uportal-background-content</xsl:attribute>
		 </xsl:if>
            <TD WIDTH="30%" class="uportal-text">
                <xsl:value-of select="annee"/>
            </TD>
            <TD WIDTH="30%" class="uportal-text">
                <xsl:value-of select="grade"/>
            </TD>
            <TD WIDTH="20%" class="uportal-text">
				<xsl:choose>
				<xsl:when test="note_proposee != 'null'">
            	<xsl:value-of select="note_proposee"/>
				</xsl:when>
				</xsl:choose>
            </TD>
            <TD WIDTH="20%" class="uportal-text">
				<xsl:choose>
				<xsl:when test="note_definitive != 'null'">
            	<xsl:value-of select="note_definitive"/>
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
				</xsl:choose>
            </TD>
	        </TR>
    </xsl:template>
</xsl:stylesheet>
