<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genIndividu.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="genIndividu">
         <xsl:with-param name="civilite" select="xml/individu/civilite" />

         <xsl:with-param name="dossier" select="xml/individu/dossier" />

         <xsl:with-param name="nom_patro" select="xml/individu/nom_patro" />

         <xsl:with-param name="nom_usuel" select="xml/individu/nom_usuel" />

         <xsl:with-param name="prenom" select="xml/individu/prenom" />

      </xsl:call-template>

      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>C O N T R A T</b>

            <br />

            <br />
         </P>
      </div>

      <xsl:apply-templates select="xml/contrats" />
   </xsl:template>

   <xsl:template match="contrats">
      <xsl:if test="count(contrat) != 0">
         <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
            <TR class="uportal-background-light">
               <TD HEIGHT="30"> 
                  <P ALIGN="LEFT" class="uportal-channel-strong">Contrat</P>
               </TD>
            </TR>
         </TABLE>
         <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	       <TR>
	       <TD WIDTH="20%" class="uportal-channel-strong">Période</TD>
   	       <TD WIDTH="30%" class="uportal-channel-strong">Equiv. Grade</TD>
	       <TD WIDTH="50%" class="uportal-channel-strong">Quotité</TD>
      	 </TR>
          <xsl:apply-templates select="contrat" />
      	</TABLE>
      </xsl:if>
      <xsl:if test="count(contrat) = 0">
		   <p align="center" class="uportal-channel-strong">Pas de contrat en cours.</p>
      </xsl:if>
   </xsl:template>

   <xsl:template match="contrat">
  	   <TR valign="top">
		 <xsl:if test="position() mod 2 = 0">
		   <xsl:attribute name="class">uportal-background-highlight</xsl:attribute>
		 </xsl:if>
		 <xsl:if test="position() mod 2 = 1">
		   <xsl:attribute name="class">uportal-background-content</xsl:attribute>
		 </xsl:if>
      <TD WIDTH="20%" class="uportal-text"><a href="{$baseActionURL}?action=detailcontrat&amp;contrat={numero}&amp;avenant={avenant}"><xsl:value-of select="periode" /></a></TD>
	    <TD WIDTH="30%" class="uportal-text"><xsl:if test="grade != 'null'"><xsl:value-of select="grade" /></xsl:if></TD>
	    <TD WIDTH="50%" class="uportal-text"><xsl:value-of select="quotite" /></TD>
      </TR>
   </xsl:template>

</xsl:stylesheet>

