<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

<!-- action des liens -->
   <xsl:variable name="action_etat_civil">etat_civil</xsl:variable>

   <xsl:variable name="action_carriere">carriere</xsl:variable>

   <xsl:variable name="action_contrat">contrat</xsl:variable>

   <xsl:variable name="action_agent">agent</xsl:variable>

   <xsl:variable name="action_avancement">avancement</xsl:variable>


<!-- libelle des liens -->

   <xsl:variable name="libelle_etat_civil">Etat-civil</xsl:variable>

   <xsl:variable name="libelle_carriere">Carrière</xsl:variable>
 
   <xsl:variable name="libelle_contrat">Contrat</xsl:variable>

   <xsl:variable name="libelle_agent">Agent</xsl:variable>

   <xsl:variable name="libelle_avancement">Avancement</xsl:variable>

<!-- images des liens -->
   <xsl:variable name="image_etat_civil">etatCivil.gif</xsl:variable>

   <xsl:variable name="image_carriere">home.gif</xsl:variable>

   <xsl:variable name="image_contrat">note.gif</xsl:variable>

   <xsl:variable name="image_agent">inscription.gif</xsl:variable>

   <xsl:variable name="image_avancement">calendrier.gif</xsl:variable>

<!-- Modele horizontal -->

   <xsl:template name="liensHorizontaux">
      <xsl:param name="annuaire">none</xsl:param>
      
      <br />

      <table align="center">
         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <img alt="{$libelle_etat_civil}" border="0" src="{$mediaPath}/{$image_etat_civil}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <xsl:value-of select="$libelle_etat_civil" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_agent}">
                  <img alt="{$libelle_agent}" border="0" src="{$mediaPath}/{$image_agent}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_agent}">
                  <xsl:value-of select="$libelle_agent" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_carriere}">
                  <img alt="{$libelle_carriere}" border="0" src="{$mediaPath}/{$image_carriere}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_carriere}">
                  <xsl:value-of select="$libelle_carriere" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_contrat}">
                  <img alt="{$libelle_contrat}" border="0" src="{$mediaPath}/{$image_contrat}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_contrat}">
                  <xsl:value-of select="$libelle_contrat" />
               </a>
            </td>

            <td width="2%" align="center">|</td>

            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_avancement}">
                  <img alt="{$libelle_avancement}" border="0" src="{$mediaPath}/{$image_avancement}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_avancement}">
                  <xsl:value-of select="$libelle_avancement" />
               </a>
            </td>

         </tr>
      </table>
   </xsl:template>

<!-- Modele vertical -->
   <xsl:template name="liensVerticaux">
      <xsl:param name="annuaire">none</xsl:param>

      <table>
         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <img alt="{$libelle_etat_civil}" border="0" src="{$mediaPath}/{$image_etat_civil}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_etat_civil}">
                  <xsl:value-of select="$libelle_etat_civil" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_agent}">
                  <img alt="{$libelle_agent}" border="0" src="{$mediaPath}/{$image_agent}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_agent}">
                  <xsl:value-of select="$libelle_agent" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_carriere}">
                 <img alt="{$libelle_carriere}" border="0" src="{$mediaPath}/{$image_carriere}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_carriere}">
                  <xsl:value-of select="$libelle_carriere" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_contrat}">
                 <img alt="{$libelle_contrat}" border="0" src="{$mediaPath}/{$image_contrat}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_contrat}">
                  <xsl:value-of select="$libelle_contrat" />
               </a>
            </td>
         </tr>

         <tr>
            <td valign="absmiddle">
               <a href="{$baseActionURL}?action={$action_avancement}">
                 <img alt="{$libelle_avancement}" border="0" src="{$mediaPath}/{$image_avancement}" />
               </a>
            </td>

            <td class="uportal-channel-subtitle" nowrap="true">
               <a href="{$baseActionURL}?action={$action_avancement}">
                  <xsl:value-of select="$libelle_avancement" />
               </a>
            </td>
         </tr>

      </table>
   </xsl:template>
</xsl:stylesheet>

