/**
 * 
 * <p>CConsultHarpege</p>
 * <p>Description : Consultation du dossier personnel d'HARPEGE</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-Marc GULLUNG</a>
 * @version 1.0
 *
 */
package org.esupportail.portal.channels.gestion.CConsultHarpege;

import java.sql.SQLException;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Priority;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IServant;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;
import org.esupportail.portal.channels.gestion.CConsultHarpege.Utils;
import org.esupportail.portal.channels.gestion.CConsultHarpege.Config;
import org.esupportail.portal.channels.CMailTo.Mail.Mail;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.FatalError;
import org.esupportail.portal.utils.channels.plugins.RestrictedAction;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.connectors_harpege.HarpegeConnector;
import org.esupportail.portal.utils.connectors_harpege.ConnectorException;
import org.esupportail.portal.utils.database.Query;

public class CConsultHarpege extends MainChannel {

	protected static final Log log = LogFactory.getLog(CConsultHarpege.class);

	// id de l'utilisateur
	private String userId;
	// no_individu de l'individu
	protected String no_individu;
	// flux xml correspondant  l'en-tte des diffrentes pages
	private String xmlIndividu;

	public CConsultHarpege() throws PortalException {
	    try {
			setConfigActions(Config.getInstance());
		} catch (PortalException e) {
			log.error("CConsultHarpege:CConsultHarpege() : probleme avec la config ");
		} 
		Message.register(this);
	}

	/** 
	 *  Receive static channel data from the portal.
	 *  Satisfies implementation of IChannel Interface.
	 *
	 *  @param <b>ChannelStaticData</b> sd static channel data
	 * @throws PortalException
	 */
	public void setStaticData(ChannelStaticData sd) throws PortalException {
		super.setStaticData(sd);
		userId = (String) staticData.getPerson().getAttribute(IPerson.USERNAME);
		no_individu = getNoIndividu();
	}

	/**
	 * Rcupration du no_individu de l'agent
	 *
	 */
	public String getNoIndividu() {

		if (no_individu == null) {

			// on rcupre le no_individu via le connecteur Harpege
			try {
				no_individu = HarpegeConnector.getNO_INDIVIDU(getStaticData().getPerson());
			} 
			catch (ConnectorException e1) {
				// enregistrement plugin fatalError
				FatalError.fatalError(this, Config.getInstance().getMsgInterdit());
				return null;
			}
		}

		return no_individu;
	}

	/**
	 * Mthode qui retourne les infos principales de l'agent sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlIndividu() throws FrameWorkException {
		Query qry = null;
		boolean error = false;
		StringBuffer res = null;

		if (xmlIndividu == null) {
			res = new StringBuffer("<individu>");
			//	Connexion  la base et excution d'une requte

			try {
				no_individu = getNoIndividu();
				if (no_individu != null) { // la personne connecte  un no_individu
					qry = Config.getInstance().getConnexionDefault();
					qry.setSql("select i.no_individu,i.c_civilite,i.nom_usuel,i.nom_patronymique,i.prenom,p.numen from individu i, personnel p where i.no_individu = ? and i.no_individu=p.no_dossier_pers(+)");
					qry.getStmt().setString(1, no_individu);
					qry.select();			   
					while (qry.getRs().next()){
						res.append("<dossier>").
						append(Utils.xmlEscape(qry.getRs().getString("no_individu"))).
						append("</dossier>");
						res.append("<nom_usuel>").
						append(Utils.xmlEscape(qry.getRs().getString("nom_usuel"))).
						append("</nom_usuel>");
						res.append("<nom_patro>").
						append(Utils.xmlEscape(qry.getRs().getString("nom_patronymique"))).
						append("</nom_patro>");
						res.append("<prenom>").
						append(Utils.xmlEscape(qry.getRs().getString("prenom"))).
						append("</prenom>");
						res.append("<civilite>").
						append(Utils.xmlEscape(qry.getRs().getString("c_civilite"))).
						append("</civilite>");
						res.append("<numen>").
						append(Utils.xmlEscape(qry.getRs().getString("numen"))).
						append("</numen>");
						res.append("<nouscontacter>").append(Config.getInstance().getNousContacter()).append("</nouscontacter>");
					}
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("CConsultHarpege::getXmlIndividu() : Erreur SQL " + e);
		        }
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("CConsultHarpege::getXmlIndividu() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}

			res.append("</individu>");
		}
		return res;
	}

	/**
	 * Mthode qui permet de positionner no_individu  une valeur autre que celle de l'individu 
	 * 
	 */
	public void setNoIndividu(String no_ind) {
		no_individu=no_ind;
	}

	/**
	 * Mthode qui donne l'identit de l'individu (civilite Prnom Nom (no_individu)
	 */
	public String getIdentite() {
		Query qry = null;
		boolean error = false;
		String res = null;

		try {
			no_individu = getNoIndividu();
			if (no_individu != null) { // la personne connecte  un no_individu
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select i.no_individu,i.c_civilite,i.nom_usuel,i.nom_patronymique,i.prenom,p.numen from individu i, personnel p where i.no_individu = ? and i.no_individu=p.no_dossier_pers(+)");
				qry.getStmt().setString(1, no_individu);
				qry.select();			   
				while (qry.getRs().next()){
					if (qry.getRs().getString("c_civilite") == "MME") {
						res=Utils.xmlEscape(qry.getRs().getString("c_civilite")) + " " + Utils.xmlEscape(qry.getRs().getString("prenom")) + " " + Utils.xmlEscape(qry.getRs().getString("nom_usuel")) + " ne " + Utils.xmlEscape(qry.getRs().getString("nom_patronymique")) + " (" + Utils.xmlEscape(qry.getRs().getString("no_individu")) + ")";
					}
					else {
						res=Utils.xmlEscape(qry.getRs().getString("c_civilite")) + " " + Utils.xmlEscape(qry.getRs().getString("prenom")) + " " + Utils.xmlEscape(qry.getRs().getString("nom_patronymique")) + " (" + Utils.xmlEscape(qry.getRs().getString("no_individu")) + ")";
					}
				}
			}
		} 
		catch (SQLException e) {
			if (log.isDebugEnabled()){
	        	log.error("CConsultHarpege::getIdentite() : Erreur SQL " + e);
	        }
		}
		catch (Exception e) {
			if (log.isDebugEnabled()){
	        	log.error("CConsultHarpege::getIdentite() : Erreur SQL " + e);
	        }
			error = true;
		}
		finally {
			qry.close();
		}

		return res;
	}

	/**
	 * Mthode appele lors de l'appel  un canal servant<br>
	 * permettant de fixer des paramtres pour ce canal
	*/ 
	public void initServant(IServant servant) throws PortalException {

	    Iterator i = this.getCurrentAction().getParams().keySet().iterator();

		/*Rcupration des paramtres sur les actions*/
		while (i.hasNext()){
		    String apName = (String)i.next();

		    String param = null;

		    if (apName.equals("from")){
		        param = Mail.FROM;
		    }else if (apName.equals("to")){
		        param = Mail.TO;
		    }else if (apName.equals("subject")){
		        param = Mail.SUBJECT;
		    }else if (apName.equals("cc")){
		        param = Mail.CC;
		    }else if (apName.equals("bcc")){
		        param = Mail.BCC;
		    }else if (apName.equals("content")){
		        param = Mail.CONTENT;
		    }else if (apName.equals("server")){
		        param = Mail.SERVER;
		    }

		    ActionParam ap = (ActionParam)this.getCurrentAction().getParams().get(apName);
		    Iterator j = ap.getValues().iterator();
		    int count = 0;

		    String[] att = new String[ap.getValues().size()]; 
		    while (j.hasNext()){
		        String val = (String)j.next();
		        att[count] = val;
		        count++;
		    }
		    runtimeData.setParameterValues(param,att);
		}

		// Traitement pour le sujet du message
		String param = Mail.SUBJECT;
		String[] att = new String[3];
		att[0] = "Demande faite par " + getIdentite();
		att[1] = "false";
		att[2] = "true";
		runtimeData.setParameterValues(param,att);

		// Appel  CMailTo en mode servant
		super.initServant(servant);
	}
}
