package org.esupportail.portal.channels.gestion.CConsultHarpege;

import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.xml.sax.ContentHandler;

/**
 * 
 * <p>CConsultHarpegeServant</p>
 * <p>Description : Extension en servant de ConsultHarpege</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-Marc GULLUNG</a>
 * @version 1.1
 *
 */
public class ConsultHarpegeServant extends CConsultHarpege implements IServant {

	/**
	 * Constructeur
	 * @throws PortalException
	 */
	public ConsultHarpegeServant() throws PortalException  {
		super();
	}

	/**
	 * retourne true ou false si le servant a fini de travailler
	 * pour se terminer, le canal doit recevoir : servantFinished
	 * qui est en fait le nom d'un bouton sur la feuille xsl 
	 * @return True si le servant est fini, False sinon
	 */
	public boolean isFinished() {
		if (runtimeData.getParameter("servantFinished") != null)
			return true;
		return false;
	}

	/**
	 * Retourne les Personnes trouves en rsultat de la recherche
	 * @return Object[] ( caster en Personne), Null sinon
	 */
	public Object[] getResults() {
		return null;
	}

	/**
	 * Ajoute un paramtre au staticData du servant
	 */
	public void setStaticData(ChannelStaticData sd) throws PortalException {
		super.setStaticData(sd);
	}

	public void renderXML(ContentHandler out) throws PortalException {
		// on passe  toutes les subchannel non servant le fait qu'elles travaillent en mode servant (feuille XSL)
		if (!currentAction.isServant())
			currentSubChannel.getXSLParameter().put("modeServant","1");
		super.renderXML(out);
	}	
}
