<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genIndividu.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="genIndividu">
         <xsl:with-param name="civilite" select="xml/individu/civilite" />

         <xsl:with-param name="dossier" select="xml/individu/dossier" />

			<xsl:with-param name="numen" select="xml/individu/numen" />

         <xsl:with-param name="nom_patro" select="xml/individu/nom_patro" />

         <xsl:with-param name="nom_usuel" select="xml/individu/nom_usuel" />

         <xsl:with-param name="prenom" select="xml/individu/prenom" />

         <xsl:with-param name="nouscontacter" select="xml/individu/nouscontacter" />

      </xsl:call-template>

      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>A V A N C E M E N T</b>

            <br />

            <br />
         </P>
      </div>

      <xsl:apply-templates select="xml/avancement" />
   </xsl:template>

   <xsl:template match="avancement">
      <xsl:if test="count(categorie) != 0">
      <TABLE CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Catégorie</TD>
            <TD colspan="2" WIDTH="70%" class="uportal-channel-text"><xsl:value-of select="categorie" /></TD>       
         </TR>
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Corps</TD>
            <TD colspan="2" WIDTH="70%" class="uportal-channel-text"><xsl:value-of select="corps" /></TD>       
         </TR>
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Grade</TD>
            <TD colspan="2" WIDTH="70%" class="uportal-channel-text"><xsl:value-of select="grade" /></TD>       
         </TR>
         <TR>
            <TD WIDTH="100%" colspan="3">
               <TABLE WIDTH="100%">
                  <TR>
                     <TD WIDTH="30%"></TD>
                     <TD WIDTH="30%" class="uportal-channel-strong"><B>Situation Actuelle</B></TD>
                     <TD WIDTH="40%" class="uportal-channel-strong"><B>Situation Future</B></TD>
                  </TR>
               </TABLE>
            </TD>
         </TR>
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Echelon</TD>
            <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="echelon_actuel" /></TD>       
            <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="echelon_futur" /></TD>       
         </TR>
		<xsl:if test="chevron_actuel != 'null' or chevron_futur != 'null'">
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Chevron</TD>
            <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="chevron_actuel" /></TD>       
            <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="chevron_futur" /></TD>       
         </TR>
		</xsl:if>
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Indice Brut</TD>
            <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="indice_brut_actuel" /></TD>       
            <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="indice_brut_futur" /></TD>       
         </TR>
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Indice Majoré</TD>
            <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="indice_majore_actuel" /></TD>       
            <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="indice_majore_futur" /></TD>       
         </TR>
         <TR>
            <TD WIDTH="30%" class="uportal-channel-strong">Date d'effet</TD>
            <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="date_effet_actuel" /></TD>       
            <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="date_effet_futur" /></TD>       
         </TR>
      </TABLE>
	</xsl:if>
	<xsl:if test="count(categorie) = 0">
        <p class="uportal-channel-strong" align="center">Pas de calcul d'avancement possible pour vous.</p>
	</xsl:if>
  </xsl:template>

</xsl:stylesheet>

