package org.esupportail.portal.channels.gestion.CConsultHarpege;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.ConfigChannel;

//import org.esupportail.portal.utils.connectors_harpege.HarpegeConnector;
//import org.esupportail.portal.utils.connectors_harpege.ConnectorException;

/**
 * 
 * <p>ConfigChannel</p>
 * <p>Classe permettant d'accder  la configuration de la channel CConsultHarpege</p>
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-Marc GULLUNG</a>
 * @version 1.0
 *
 */
public class Config extends ConfigChannel
{ 
	//dclaration des variables de la classe
	private static Config singleton = null;

	//message d'interdiction
	private String msgInterdit;
	
	//affiche ou non le lien "nous contacter"
	private String nousContacter;

	/**
	* 
	* @return ConfigChannel Instance
	* @throws IOException
	* @throws JspException
	*/
	public static Config getInstance() {
	if (singleton == null) {
		 singleton = new Config();
		 }
	return singleton;
	}

	/**
	 * Mthode qui permet d'ajouter une personnalisation sur les rgles que doit prendre en compte
	 * le digester
	 */
	protected void customDigester() {
		dig.addCallMethod("config","addRoot",2);
		dig.addCallParam("config/msgInterdit",0);
		dig.addCallParam("config/nousContacter",1);
	}

	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.channels.ConfigChannel#getConfigFile()
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CConsultHarpege/CConsultHarpege.xml";
	}
	
	public void addRoot(String msgInterdit, String nousContacter){
		this.msgInterdit = msgInterdit;
		this.nousContacter = nousContacter;
	}

	/**
	 * @return Returns the msgInterdit.
	 */
	public String getMsgInterdit() {
		return msgInterdit;
	}
	/**
	 * @param msgInterdit The msgInterdit to set.
	 */
	public void setMsgInterdit(String msgInterdit) {
		this.msgInterdit = msgInterdit;
	}
	
	/**
	 * @return Returns the nousContacter
	 */
	public String getNousContacter() {
		return nousContacter;
	}
}

