<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genIndividu.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="genIndividu">
         <xsl:with-param name="civilite" select="xml/individu/civilite" />

         <xsl:with-param name="dossier" select="xml/individu/dossier" />

			<xsl:with-param name="numen" select="xml/individu/numen" />

         <xsl:with-param name="nom_patro" select="xml/individu/nom_patro" />

         <xsl:with-param name="nom_usuel" select="xml/individu/nom_usuel" />

         <xsl:with-param name="prenom" select="xml/individu/prenom" />

         <xsl:with-param name="nouscontacter" select="xml/individu/nouscontacter" />

      </xsl:call-template>

      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>D E T A I L - C A R R I E R E</b>

            <br />

            <br />
         </P>
      </div>

      <xsl:apply-templates select="xml/avoir/carriere" />
	  <xsl:apply-templates select="xml/avoir/occupations" />
	  <xsl:apply-templates select="xml/avoir/affectations" />
   </xsl:template>

   <xsl:template match="avoir/carriere">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Carrière</P>
            </TD>
         </TR>
	</TABLE>
	<TABLE>
	 <TR>
	    <TD WIDTH="20%" class="uportal-channel-strong">B.A.P.</TD>
	    <TD WIDTH="80%" colspan="3" class="uportal-channel-strong"><xsl:value-of select="bap" />
			&#160;-&#160;<xsl:value-of select="lib_bap" />
		</TD>
	 </TR>
	 <TR valign="top">
	    <TD WIDTH="20%" class="uportal-channel-strong">Catégorie</TD>
	    <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="categorie" /></TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Type d'accés</TD>
	    <TD WIDTH="20%" class="uportal-channel-text"><xsl:value-of select="typeacces" /></TD>
	 </TR>
	 <TR valign="top">
	    <TD WIDTH="20%" class="uportal-channel-strong">Date d'effet</TD>
	    <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="dateeffet" /></TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Echelon</TD>
	    <TD WIDTH="20%" class="uportal-channel-text"><xsl:value-of select="echelon" /></TD>
	 </TR>
	 <TR valign="top">
	    <TD WIDTH="20%" class="uportal-channel-strong">Corps</TD>
	    <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="corps" /></TD>
		    <TD WIDTH="20%" class="uportal-channel-strong">Chevron</TD>
		    <TD WIDTH="20%" class="uportal-channel-strong">Indice Brut</TD>
	    <TD WIDTH="20%" class="uportal-channel-text">
	    	<xsl:value-of select="indicebrut" />
	    </TD>
	 </TR>
	 <TR valign="top">
	    <TD WIDTH="20%" class="uportal-channel-strong">Grade</TD>
	    <TD WIDTH="40%" class="uportal-channel-text"><xsl:value-of select="grade" /></TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Indice Majoré</TD>
	    <TD WIDTH="20%" class="uportal-channel-text">
	    	<xsl:value-of select="indicemajore" />
	    </TD>
	 </TR>
	 </TABLE>
	</xsl:template>

   <xsl:template match="avoir/occupations">
	<xsl:if test="count(occupation) != 0">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Occupation</P>
            </TD>
         </TR>
	</TABLE>
	<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	 <TR>
	    <TD WIDTH="10%" class="uportal-channel-strong">N° du poste</TD>
	    <TD WIDTH="10%" class="uportal-channel-strong">N° national</TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Période</TD>
	    <TD WIDTH="60%" class="uportal-channel-strong">Profil</TD>
	 </TR>
	<xsl:apply-templates select="occupation" />
	</TABLE>
	</xsl:if>
	</xsl:template>

	<xsl:template match="occupation">
	 <TR valign="top">
	    <TD WIDTH="10%" class="uportal-channel-text"><xsl:value-of select="poste" /></TD>
	    <TD WIDTH="10%" class="uportal-channel-text"><xsl:value-of select="postenational" /></TD>
	    <TD WIDTH="20%" class="uportal-channel-text"><xsl:value-of select="periodeoccupation" /></TD>
		<TD WIDTH="60%" class="uportal-channel-text">
		<xsl:if test="profil != 'null'">
			<xsl:value-of select="profil" />
		</xsl:if>
		</TD>
	 </TR>
	</xsl:template>

   <xsl:template match="avoir/affectations">
	<xsl:if test="count(affectation) != 0"> 
     <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Affectation</P>
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	 <TR>
	    <TD WIDTH="30%" class="uportal-channel-strong">Structure</TD>
	    <TD WIDTH="25%" class="uportal-channel-strong">Période</TD>
	    <TD WIDTH="10%" class="uportal-channel-strong">N° du poste</TD>
	    <TD WIDTH="5%" class="uportal-channel-strong">Quotité</TD>
	    <TD WIDTH="30%" class="uportal-channel-strong">Adresse</TD>
	 </TR>
	<xsl:apply-templates select="affectation" />
	</TABLE>
	</xsl:if>
   </xsl:template>

   <xsl:template match="affectation">
	 <TR valign="top">
	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="structureaff" /></TD>
	    <TD WIDTH="25%" class="uportal-channel-text"><xsl:value-of select="periodeaff" /></TD>
	    <TD WIDTH="10%" class="uportal-channel-text"><xsl:value-of select="posteaff" /></TD>
	    <TD WIDTH="5%" class="uportal-channel-text"><xsl:value-of select="quotite" /> %</TD>
	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="rueaff" /><BR />
	    <xsl:value-of select="localiteaff" /><BR />
	    <xsl:value-of select="villeaff" />
	    </TD>
	 </TR>
	 <TR valign="top">
	 <TD WIDTH="100%" COLSPAN="5" HEIGHT="10">&#160;</TD>
	 </TR>
	</xsl:template>
</xsl:stylesheet>

