/**
 * Agent<br>
 * <br>
 * Vie de l'agent intra et extra tablissement<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr.fr">Jean-marc Gullung</a>
 * @version 1.0
 * 
 */
package org.esupportail.portal.channels.gestion.CConsultHarpege;

import java.sql.SQLException;
import org.apache.log4j.Priority;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CConsultHarpege.Utils;

public class Agent extends SubChannel  {

	protected static final Log log = LogFactory.getLog(Agent.class);
	
	// Classe principale de la channel
	private CConsultHarpege owner;

	// flux xml : calcul qu'une seul fois, raffich ensuite
	private StringBuffer xml; 
		
	/**
	 * Contructeur de la classe
	 * @param main
	 */
	public Agent(MainChannel main) {
		super(main);
		owner = (CConsultHarpege)main;
	}

	public Boolean setXML() throws FrameWorkException {
		
		if (xml == null) {
			xml = new StringBuffer(START_XML);
			xml.append(owner.getXmlIndividu());
			xml.append(getXmlPosition());
			xml.append(getXmlTempsPartiels());
			xml.append(getXmlBonification());
			xml.append(getXmlServiceHorsEtablissement());
			xml.append(getXmlNotation());
			xml.append(END_XML);		
		}
    	log.debug(xml);

		setXML(xml.toString());
			
		return Boolean.TRUE;
	}
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		return res;	
	}
	
	/**
	 * Mthode qui retourne les positions d'un individu sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlPosition() throws FrameWorkException {
		
		StringBuffer res = new StringBuffer("<positions>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select p.ll_position, to_char(cp.d_deb_position,'DD/MM/YYYY') date_position, mp.ll_motif_position from changement_position cp, position p, motif_position mp where cp.no_dossier_pers= ? and cp.c_position=p.c_position and mp.c_motif_position(+)=cp.c_motif_position");
      		qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
               res.append("<position>");
					res.append("<lib_position>").
					append(Utils.xmlEscape(qry.getRs().getString("ll_position"))).
					append("</lib_position>");
					res.append("<motif_position>").
					append(Utils.xmlEscape(qry.getRs().getString("ll_motif_position"))).
					append("</motif_position>");
					res.append("<date_position>").
					append(Utils.xmlEscape(qry.getRs().getString("date_position"))).
					append("</date_position>");
               res.append("</position>");
				}
			}
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlPosition() : Erreur SQL " + e);
		        }
				error = true;
				throw new FrameWorkException();
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlPosition() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
		   }
		}

		res.append("</positions>");
		
		return res;
	}
	
	public StringBuffer getXmlTempsPartiels() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<tempspartiels>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select to_char(d_deb_quotite,'DD/MM/YYYY') date_debut, to_char(nvl(d_fin_execution,d_fin_quotite),'DD/MM/YYYY') date_fin, to_char(d_fin_execution,'DD/MM/YYYY') date_fin_reelle, num_quotite, den_quotite from temps_partiel where no_dossier_pers=? and d_annulation is null");
				qry.getStmt().setString(1, owner.getNoIndividu());				
				qry.select();
				while (qry.getRs().next()){
				  res.append("<tempspartiel>");
					res.append("<date_debut>").append(Utils.xmlEscape(qry.getRs().getString("date_debut"))).append("</date_debut>");
					res.append("<date_fin>").append(Utils.xmlEscape(qry.getRs().getString("date_fin"))).append("</date_fin>");
					res.append("<date_fin_reelle>").append(Utils.xmlEscape(qry.getRs().getString("date_fin_reelle"))).append("</date_fin_reelle>");
					res.append("<quotite>").append(Utils.xmlEscape(qry.getRs().getString("num_quotite"))).append(" / ").append(Utils.xmlEscape(qry.getRs().getString("den_quotite"))).append("</quotite>");
					res.append("</tempspartiel>");
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlTempsPartiels() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlTempsPartiels() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}	
		}

		res.append("</tempspartiels>");

		return res;
	}	

	public StringBuffer getXmlBonification() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<bonifications>");
		Query qry = null;
		boolean error = false;
		
		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select bi.valeur_bonif_indic, to_char(bi.d_effet_bonif_indic,'DD/MM/YYYY') date_effet, tbi.ll_type_bonif_indic from bonif_indiciaire bi, type_bonif_indic tbi where bi.no_dossier_pers= ? and bi.c_type_bonif_indic(+)=tbi.c_type_bonif_indic");

				qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
	            res.append("<bonification>");
					res.append("<bonification_libelle>").append(Utils.xmlEscape(qry.getRs().getString("ll_type_bonif_indic"))).append("</bonification_libelle>");
					res.append("<bonification_point>").append(Utils.xmlEscape(qry.getRs().getString("valeur_bonif_indic"))).append("</bonification_point>");
					res.append("<bonification_date>").append(Utils.xmlEscape(qry.getRs().getString("date_effet"))).append("</bonification_date>");
					res.append("</bonification>");
				}
			}
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlBonification() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlBonification() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}	
		}

		res.append("</bonifications>");

		return res;
	}

	public StringBuffer getXmlServiceHorsEtablissement() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<services>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();

				qry.setSql("select to_char(d_deb_passe,'DD/MM/YYYY') date_debut, to_char(d_fin_passe,'DD/MM/YYYY') date_fin, etablissement_passe, fonction_passe, nvl(duree_validee_annees,0) duree_validee_annees, nvl(duree_validee_mois,0) duree_validee_mois from passe where no_dossier_pers= ? order by d_deb_passe");
				qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
					res.append("<service>");
					res.append("<periode>").append("Du ").append(Utils.xmlEscape(qry.getRs().getString("date_debut"))).append(" au ").append(Utils.xmlEscape(qry.getRs().getString("date_fin"))).append("</periode>");
					res.append("<etablissement>").append(Utils.xmlEscape(qry.getRs().getString("etablissement_passe"))).append("</etablissement>");
					res.append("<fonction>").append(Utils.xmlEscape(qry.getRs().getString("fonction_passe"))).append("</fonction>");
					res.append("<duree_annee>").append(Utils.xmlEscape(qry.getRs().getString("duree_validee_annees"))).append("</duree_annee>");
					res.append("<duree_mois>").append(Utils.xmlEscape(qry.getRs().getString("duree_validee_mois"))).append("</duree_mois>");
					res.append("</service>");
				}
			}
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlServiceHorsEtablissement() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlServiceHorsEtablissement() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		}

		res.append("</services>");

		return res;
	}

	public StringBuffer getXmlNotation() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<notes>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select n.annee_notation, g.ll_grade, n.note_proposee, n.note_definitive from notes n, grade g where n.no_dossier_pers= ? and g.c_grade(+)=n.c_grade order by n.annee_notation");

				qry.getStmt().setString(1, owner.getNoIndividu());				
				qry.select();
				while (qry.getRs().next()){
					res.append("<note>");
					res.append("<annee>").append(Utils.xmlEscape(qry.getRs().getString("annee_notation"))).append("</annee>");
					res.append("<grade>").append(Utils.xmlEscape(qry.getRs().getString("ll_grade"))).append("</grade>");
					res.append("<note_proposee>").append(Utils.xmlEscape(qry.getRs().getString("note_proposee"))).append("</note_proposee>");
					res.append("<note_definitive>").append(Utils.xmlEscape(qry.getRs().getString("note_definitive"))).append("</note_definitive>");
					res.append("</note>");
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlNotation() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Agent::getXmlNotation() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		}

		res.append("</notes>");

		return res;
	}	
}	
