package org.esupportail.portal.channels.gestion.CConsultHarpege;

import java.sql.SQLException;
import java.lang.Integer;
import org.apache.log4j.Priority;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CConsultHarpege.Utils;

/**
 * Avancement<br>
 * <br>
 * Calcul du prochain avancement de l'agent<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-marc Gullung</a>
 * @version 1.0
 * 
 */
public class Avancement extends SubChannel  {

	protected static final Log log = LogFactory.getLog(Avancement.class);
	
	// Classe principale de la channel
	private CConsultHarpege owner;

	// flux xml : calcul qu'une seul fois, raffich ensuite
	private StringBuffer xml; 
		
	/**
	 * Contructeur de la classe
	 * @param main
	 */
	public Avancement(MainChannel main) {
		super(main);
		owner = (CConsultHarpege)main;
	}

	public Boolean setXML() throws FrameWorkException {
		
		if (xml == null) {
			xml = new StringBuffer(START_XML);
			xml.append(owner.getXmlIndividu());
			xml.append(getXmlAvancement());
			xml.append(END_XML);		
		}
		setXML(xml.toString());
			
		return Boolean.TRUE;
	}
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		return res;	
	}
	
	/**
	 * Mthode qui retourne les donnes d'un personnel et calcule son prochain avancement sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlAvancement() throws FrameWorkException {

		StringBuffer res = new StringBuffer("<avancement>");
		Query qry = null;
		boolean error = false;

		// Requte
		String requete=null;

		// Corps
		String corps=null;

		// Grade
		String grade=null;

		// Categorie
		String categorie=null;

		// Echelon
		String echelon=null;

		// Echelon suivant
		String echelon_suivant=null;

		// Chevron
		String chevron=null;

		// Chevron suivant
		String chevron_suivant=null;

		// Duree de passage  l'echelon superieur
		int duree_annee=0;
		int duree_mois=0;

		// Anciennete dans l'echelon
		int anc_annee=0;
		int anc_mois=0;

		// Variable de calcul
		int Futur=0;
		int Anciennete=0;

		// Nombre de mois avant le prochain changement d'echelon
		int NbMois=0;

		// Numro de carrire
		int no_seq_carriere=0;
		
		// Numro de l'lment de carrire
		int no_seq_element=0;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select vpc.no_seq_carriere,vpc.no_seq_element,vpc.c_corps, vpc.c_grade,c.c_categorie,ec.rep_anc_ech_annees,ec.rep_anc_ech_mois,to_char(nvl(vpc.d_effet_chevron,vpc.d_effet_element),'DD/MM/YYYY') date_effet,vpc.c_echelon,vpc.c_chevron from v_periode_carriere vpc, corps c, element_carriere ec where vpc.no_dossier_pers=? and sysdate between d_deb and nvl(d_fin,sysdate) and ec.no_dossier_pers=vpc.no_dossier_pers and ec.no_seq_carriere=vpc.no_seq_carriere and ec.no_seq_element=vpc.no_seq_element and c.c_corps=vpc.c_corps");

				qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
					res.append("<categorie>").
					append(Utils.xmlEscape(qry.getRs().getString("c_categorie"))).
					append("</categorie>");
					no_seq_carriere=qry.getRs().getInt("no_seq_carriere");
					no_seq_element=qry.getRs().getInt("no_seq_element");
					corps=qry.getRs().getString("c_corps");
					grade=qry.getRs().getString("c_grade");
					echelon=qry.getRs().getString("c_echelon");
					chevron=qry.getRs().getString("c_chevron");
					res.append("<echelon_actuel>").append(Utils.xmlEscape(echelon)).append("</echelon_actuel>");
					res.append("<chevron_actuel>").append(Utils.xmlEscape(chevron)).append("</chevron_actuel>");
					res.append("<date_effet_actuel>").append(Utils.xmlEscape(qry.getRs().getString("date_effet"))).append("</date_effet_actuel>");

					// Recuperation de l'anciennete
					anc_annee=qry.getRs().getInt("rep_anc_ech_annees");
					anc_mois=qry.getRs().getInt("rep_anc_ech_mois");
					res.append("<anc_annee>").append(anc_annee).append("</anc_annee>");
					res.append("<anc_mois>").append(anc_mois).append("</anc_mois>");
					// Calcul en nombre de mois de l'anciennete dans l'echelon
					Anciennete=(anc_annee*12)+anc_mois;
					res.append("<anc_total>").append(Anciennete).append("</anc_total>");
				}

				// Recherche du libelle du corps et du grade
				qry.setSql("select * from (SELECT ll_corps from corps where c_corps=?),(SELECT ll_grade from grade where c_grade=?)");
				qry.getStmt().setString(1, corps);
				qry.getStmt().setString(2, grade);
				qry.select();
				while(qry.getRs().next()) {
					res.append("<corps>").append(Utils.xmlEscape(qry.getRs().getString("ll_corps"))).append("</corps>");
					res.append("<grade>").append(Utils.xmlEscape(qry.getRs().getString("ll_grade"))).append("</grade>");
				}

				if (chevron == null) {
					// Recherche de l'echelon suivant
					qry.setSql("select c_echelon_suiv from echelon where c_echelon=?");
					qry.getStmt().setString(1, echelon);
					qry.select();
					while(qry.getRs().next()) {
						echelon_suivant=qry.getRs().getString("c_echelon_suiv");
					}
				}
				else {
					// Recherche du chevron suivant
					qry.setSql("select c_chevron_suiv from chevron where c_chevron=?");
					qry.getStmt().setString(1, chevron);
					qry.select();
					while(qry.getRs().next()) {
						chevron_suivant=qry.getRs().getString("c_chevron_suiv");
					}
					echelon_suivant=echelon;
				}
					
				// Situation Actuelle
				// requete="select i.c_indice_brut,i.c_indice_majore ";
				if (chevron != null) {
					 // requete+=",pc.duree_chevron_annees duree_annees,pc.duree_chevron_mois duree_mois from indice i, passage_chevron pc where pc.c_grade=? and pc.c_echelon=? and pc.c_chevron=? and i.c_indice_brut=pc.c_chevron";
					 requete="SELECT mi.c_indice_chevron c_indice_brut,mi.c_indice_majore,pc.duree_chevron_annee duree_annees,pc.duree_chevron_mois duree_mois FROM MAJORATION_INDICE mi, CHEVRON pc, GRADE_GRILLE_INDICIAIRE ggi, GRILLE_INDICIAIRE_ECHELON gie WHERE ggi.c_grade=? AND gie.c_echelon=? AND pc.c_chevron=? AND ggi.d_fin_validite IS NULL AND mi.c_indice_chevron=pc.c_chevron AND mi.d_fin_validite IS NULL AND gie.no_grille_indiciaire=ggi.no_grille_indiciaire ";
				}
				else {
					// requete+=",pe.duree_passage_annees duree_annees,pe.duree_passage_mois duree_mois from indice i, passage_echelon pe where pe.c_grade=? and pe.c_echelon=? and i.c_indice_brut=pe.c_indice_brut";
					requete="select i.c_indice_brut,mi.c_indice_majore ,gae.duree_anciennete_annees duree_annees,gae.duree_anciennete_mois duree_mois from indice_brut i, majoration_indice mi, grille_avancement_echelon gae, grade_grille_avancement gga, grille_indiciaire_echelon gie, grade_grille_indiciaire ggi where ggi.c_grade=? and gie.c_echelon=? and ggi.d_fin_validite is null and i.c_indice_brut=mi.c_indice_chevron and mi.d_fin_validite is null and gae.no_grille_avancement=gga.no_grille_avancement and ggi.c_grade=gga.c_grade and gga.d_fin_validite is null and ggi.no_grille_indiciaire=gie.no_grille_indiciaire and gie.c_indice_brut=i.c_indice_brut and gae.c_echelon=gie.c_echelon";
				}
				qry.setSql(requete);
				qry.getStmt().setString(1, grade);
				qry.getStmt().setString(2, echelon);
				if (chevron != null) {
					// Il y a un chevron pour cet echelon
					qry.getStmt().setString(3, chevron);
				}
				qry.select();
				while (qry.getRs().next()){
					res.append("<echelon_actuel>").append(Utils.xmlEscape(echelon)).
					append("</echelon_actuel>");
					res.append("<chevron_actuel>").
					append(Utils.xmlEscape(chevron)).
					append("</chevron_actuel>");
					res.append("<indice_brut_actuel>").
					append(Utils.xmlEscape(qry.getRs().getString("c_indice_brut"))).
					append("</indice_brut_actuel>");
					res.append("<indice_majore_actuel>").
					append(Utils.xmlEscape(qry.getRs().getString("c_indice_majore"))).
					append("</indice_majore_actuel>");
					duree_annee=qry.getRs().getInt("duree_annees");
					duree_mois=qry.getRs().getInt("duree_mois");
					// Calcul du nombre de mois par passer a l'echelon superieur
					Futur=(duree_annee*12)+duree_mois;
					res.append("<futur>").append(Futur).append("</futur>");
				}

				// Calcul le nombre de mois restant avant le changement d'echelon
				NbMois=Futur-Anciennete;
				res.append("<nbmois>").append(NbMois).append("</nbmois>");
				// Situation Future
				// requete="select i.c_indice_brut,i.c_indice_majore ";
				if (chevron_suivant != null) {
					// requete+=",pc.duree_chevron_annees duree_annees,pc.duree_chevron_mois duree_mois from indice i, passage_chevron pc where pc.c_grade=? and pc.c_echelon=? and pc.c_chevron=? and i.c_indice_brut=pc.c_chevron";
					requete="SELECT mi.c_indice_chevron c_indice_brut,mi.c_indice_majore,pc.duree_chevron_annee duree_annees,pc.duree_chevron_mois duree_mois FROM MAJORATION_INDICE mi, CHEVRON pc, GRADE_GRILLE_INDICIAIRE ggi, GRILLE_INDICIAIRE_ECHELON gie WHERE ggi.c_grade=? AND gie.c_echelon=? AND pc.c_chevron=? AND ggi.d_fin_validite IS NULL AND mi.c_indice_chevron=pc.c_chevron AND mi.d_fin_validite IS NULL AND gie.no_grille_indiciaire=ggi.no_grille_indiciaire ";
				}
				else {
					// requete+=",pe.duree_passage_annees duree_annees,pe.duree_passage_mois duree_mois from indice i, passage_echelon pe where pe.c_grade=? and pe.c_echelon=? and i.c_indice_brut=pe.c_indice_brut";
					 requete="select i.c_indice_brut,mi.c_indice_majore ,gae.duree_anciennete_annees duree_annees,gae.duree_anciennete_mois duree_mois from indice_brut i, majoration_indice mi, grille_avancement_echelon gae, grade_grille_avancement gga, grille_indiciaire_echelon gie, grade_grille_indiciaire ggi where ggi.c_grade=? and gie.c_echelon=? and ggi.d_fin_validite is null and i.c_indice_brut=mi.c_indice_chevron and mi.d_fin_validite is null and gae.no_grille_avancement=gga.no_grille_avancement and ggi.c_grade=gga.c_grade and gga.d_fin_validite is null and ggi.no_grille_indiciaire=gie.no_grille_indiciaire and gie.c_indice_brut=i.c_indice_brut and gae.c_echelon=gie.c_echelon";
				}
				qry.setSql(requete);
				qry.getStmt().setString(1, grade);
				qry.getStmt().setString(2, echelon_suivant);
				if (chevron_suivant != null) {
					// Il y a un chevron pour cet echelon
					qry.getStmt().setString(3, chevron_suivant);
				}
				qry.select();
				while (qry.getRs().next()){
					res.append("<echelon_futur>").append(Utils.xmlEscape(echelon_suivant)).
					append("</echelon_futur>");
					res.append("<chevron_futur>").
					append(Utils.xmlEscape(chevron_suivant)).
					append("</chevron_futur>");
					res.append("<indice_brut_futur>").
					append(Utils.xmlEscape(qry.getRs().getString("c_indice_brut"))).
					append("</indice_brut_futur>");
					res.append("<indice_majore_futur>").
					append(Utils.xmlEscape(qry.getRs().getString("c_indice_majore"))).
					append("</indice_majore_futur>");
				}

				// Calcul de la date de changement
				qry.setSql("select to_char(add_months(d_effet_element,?),'DD/MM/YYYY') date_effet_futur from element_carriere where no_dossier_pers=? and no_seq_carriere=? and no_seq_element=?");
				qry.getStmt().setInt(1, NbMois);
				qry.getStmt().setString(2, owner.getNoIndividu());
				qry.getStmt().setInt(3,no_seq_carriere);
				qry.getStmt().setInt(4,no_seq_element);
				qry.select();
				while (qry.getRs().next()) {
					res.append("<date_effet_futur>").
					append(Utils.xmlEscape(qry.getRs().getString("date_effet_futur"))).
					append("</date_effet_futur>");
				}
			}
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("Avancement::getXmlAvancement() : Erreur SQL " + e);
		        }
				error = true;
				throw new FrameWorkException();
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Avancement::getXmlAvancement() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}		
		}

		res.append("</avancement>");

		return res;
	}
}	
