package org.esupportail.portal.channels.gestion.CConsultHarpege;

import java.sql.SQLException;
import org.apache.log4j.Priority;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CConsultHarpege.Utils;

/**
 * Contrat<br>
 * <br>
 * Gestion de l'affichage des contrats de l'agent <br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-marc GULLUNG</a>
 * @version 1.0
 * 
 */
public class Contrat extends SubChannel  {

	protected static final Log log = LogFactory.getLog(Contrat.class);
	
	// Classe principale de la channel
	private CConsultHarpege owner;

	// flux xml : calcul qu'une seul fois, raffich ensuite
	private StringBuffer xml; 
		
	/**
	 * Contructeur de la classe
	 * @param main
	 */
	public Contrat(MainChannel main) {
		super(main);
		owner = (CConsultHarpege)main;
	}

	public Boolean setXML() throws FrameWorkException {
		
		if (xml == null) {
			xml = new StringBuffer(START_XML);
			xml.append(owner.getXmlIndividu());
			xml.append(getXmlContrat());

			xml.append(END_XML);		
		}
		setXML(xml.toString());
			
		return Boolean.TRUE;
	}
	
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		Boolean res = super.init(rd);
		return res;	
	}
	
	/**
	 * Mthode qui retourne les contrats d'un individu sous forme d'un flux xml 
	 * 
	 */
	public StringBuffer getXmlContrat() throws FrameWorkException {
		
		StringBuffer res = new StringBuffer("<contrats>");
		Query qry = null;
		boolean error = false;
		String datefin = null;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select no_contrat_travail, no_avenant, to_char(d_deb_contrat_trav,'DD/MM/YYYY') date_debut, to_char(d_fin_contrat_trav,'DD/MM/YYYY') date_fin, num_quot_recrutement, den_quot_recrutement, grade.lc_grade from contrat_avenant, grade where no_dossier_pers= ? and contrat_avenant.c_grade=grade.c_grade(+) and tem_annulation != 'O' and tem_confirme='O' order by D_DEB_CONTRAT_TRAV");

				qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
					res.append("<contrat>");
					res.append("<numero>").
					append(Utils.xmlEscape(qry.getRs().getString("no_contrat_travail"))).
					append("</numero>");
					res.append("<avenant>").
					append(Utils.xmlEscape(qry.getRs().getString("no_avenant"))).
					append("</avenant>");
					datefin=(qry.getRs().getString("date_fin") == null) ? "" : qry.getRs().getString("date_fin");
					if (datefin != "") {
						res.append("<periode>Du ").
						append(Utils.xmlEscape(qry.getRs().getString("date_debut"))).
						append(" au ").
						append(Utils.xmlEscape(datefin)).
						append("</periode>");
					}
					else {
						res.append("<periode>A partir du ").
						append(Utils.xmlEscape(qry.getRs().getString("date_debut"))).
						append("</periode>");
					}
					res.append("<grade>").
					append(Utils.xmlEscape(qry.getRs().getString("lc_grade"))).
					append("</grade>");
					res.append("<quotite>").
					append(Utils.xmlEscape(qry.getRs().getString("num_quot_recrutement"))).
					append(" / ").
					append(Utils.xmlEscape(qry.getRs().getString("den_quot_recrutement"))).
					append("</quotite>");
					res.append("</contrat>");
				}
			}
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("Contrat::getXmlContrat() : Erreur SQL " + e);
		        }
				error = true;
				throw new FrameWorkException();
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Contrat::getXmlContrat() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		}

		res.append("</contrats>");

		return res;
	}
}
