package org.esupportail.portal.channels.gestion.CConsultHarpege;

import java.sql.SQLException;
import org.apache.log4j.Priority;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.database.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.gestion.CConsultHarpege.Utils;

/**
 * Etat civil<br>
 * <br>
 * Gestion de l'affichage de l'tat civil de l'agent <br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-marc GULLUNG</a>
 * @version 1.0
 * 
 */

public class EtatCivil extends SubChannel  {

	protected static final Log log = LogFactory.getLog(EtatCivil.class);

	// Classe principale de la channel
	private CConsultHarpege owner;
	// nationalit

	// flux xml : calcul qu'une seul fois, raffich ensuite
	private StringBuffer xml; 

	/**
	 * Contructeur de la classe
	 * @param main
	 */
	public EtatCivil(MainChannel main) {
		super(main);
		owner = (CConsultHarpege)main;
	}

	public Boolean setXML() throws FrameWorkException {

		if (xml == null) {
			xml = new StringBuffer(START_XML);
			xml.append(owner.getXmlIndividu());
			xml.append(getXmlGeneralites());
			xml.append(getXmlInfoFamille());
			xml.append(getXmlEnfant());
			xml.append(getXmlTelephone());
			xml.append(getXmlBanque());
			xml.append(getXmlDiplome());
			xml.append(END_XML);		
		}
		setXML(xml.toString());

		return Boolean.TRUE;
	}

	/*
	 * Mthode qui retourne les informations gnrale de l'agent sous forme d'un flux xml 
	 */
	public StringBuffer getXmlGeneralites() throws FrameWorkException {

		StringBuffer res = new StringBuffer();
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select habitant_chez,to_char(d_naissance,'DD/MM/YYYY') d_naissance, ville_de_naissance,no_c_nom_voie,localite,code_postal_ville,telephone_domicile,ll_pays_adresse,no_e_mail from v_edi_ind_dos where no_individu = ?");
				qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
					res.append("<generalites>");
					res.append("<lieu_nai>").
					append(Utils.xmlEscape(qry.getRs().getString("ville_de_naissance"))).
					append("</lieu_nai>");
					res.append("<date_nai>").
					append(Utils.xmlEscape(qry.getRs().getString("d_naissance"))).
					append("</date_nai>");
					res.append("</generalites>");
					res.append("<adresse>");
					res.append("<no_voie>").append(Utils.xmlEscape(qry.getRs().getString("no_c_nom_voie"))).append("</no_voie>");
					res.append("<habitant_chez>").append(Utils.xmlEscape(qry.getRs().getString("habitant_chez"))).append("</habitant_chez>");
					res.append("<localite>").append(Utils.xmlEscape(qry.getRs().getString("localite"))).append("</localite>");
					res.append("<code_postal_ville>").append(Utils.xmlEscape(qry.getRs().getString("code_postal_ville"))).append("</code_postal_ville>");
					res.append("<telephone_domicile>").append(Utils.xmlEscape(qry.getRs().getString("telephone_domicile"))).append("</telephone_domicile>");
					res.append("<ll_pays>").append(Utils.xmlEscape(qry.getRs().getString("ll_pays_adresse"))).append("</ll_pays>");
					res.append("<email>").append(Utils.xmlEscape(qry.getRs().getString("no_e_mail"))).append("</email>");
					res.append("</adresse>");
				}
			}
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlGeneralites() : Erreur SQL " + e);
		        }
				error = true;
				throw new FrameWorkException();
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlGeneralites() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		}

		return res;
	}

	public StringBuffer getXmlInfoFamille() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<infofamille>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select sf.l_situation_famille, to_char(p.d_situation_famille,'DD/MM/YYYY') d_situation_famille, sm.l_sit_militaire, nb_enfants(p.no_dossier_pers) nb_enfants from personnel p, situation_familiale sf, situation_militaire sm where p.no_dossier_pers= ? and p.c_situation_famille=sf.c_situation_famille(+) and p.c_sit_militaire=sm.c_sit_militaire(+)");
				qry.getStmt().setString(1, owner.getNoIndividu());				
				qry.select();
				while (qry.getRs().next()){
					res.append("<sitfam_libelle>").append(Utils.xmlEscape(qry.getRs().getString("l_situation_famille"))).append("</sitfam_libelle>");
					res.append("<sitfam_date>").append(Utils.xmlEscape(qry.getRs().getString("d_situation_famille"))).append("</sitfam_date>");
					res.append("<sitmil_lib>").append(Utils.xmlEscape(qry.getRs().getString("l_sit_militaire"))).append("</sitmil_lib>");
					res.append("<nb_enfants>").append(Utils.xmlEscape(qry.getRs().getString("nb_enfants"))).append("</nb_enfants>");
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlInfoFamille() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlInfoFamille() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}	
		}

		res.append("</infofamille>");

		return res;
	}	

	public StringBuffer getXmlEnfant() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<enfants>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select nom,prenom,decode(sexe,'1','Homme','2','Femme') sexe,lieu_naissance,to_char(d_naissance,'DD/MM/YYYY') date_nai, to_char(d_deces,'DD/MM/YYYY') date_deces, nvl(pourcent_handicap,'0') pourcent_handicap from enfant where no_dossier_pers=? order by d_naissance");
				qry.getStmt().setString(1, owner.getNoIndividu());				
				qry.select();
				while (qry.getRs().next()){
					res.append("<enfant>");
					res.append("<nom_enfant>").append(Utils.xmlEscape(qry.getRs().getString("nom"))).append("</nom_enfant>");
					res.append("<prenom_enfant>").append(Utils.xmlEscape(qry.getRs().getString("prenom"))).append("</prenom_enfant>");
					res.append("<sexe_enfant>").append(Utils.xmlEscape(qry.getRs().getString("sexe"))).append("</sexe_enfant>");
					res.append("<date_nai_enfant>").append(Utils.xmlEscape(qry.getRs().getString("date_nai"))).append("</date_nai_enfant>");
					res.append("<date_deces_enfant>").append(Utils.xmlEscape(qry.getRs().getString("date_deces"))).append("</date_deces_enfant>");
					res.append("<lieu_nai_enfant>").append(Utils.xmlEscape(qry.getRs().getString("lieu_naissance"))).append("</lieu_nai_enfant>");
					res.append("<pourcent_handicap_enfant>").append(Utils.xmlEscape(qry.getRs().getString("pourcent_handicap"))).append("</pourcent_handicap_enfant>");
					res.append("</enfant>");
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlEnfant() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlEnfant() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}	
		}

		res.append("</enfants>");

		return res;		
	}
	public StringBuffer getXmlTelephone() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<coor_tel>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();

				qry.setSql("select no_telephone telephone from INDIVIDU_TELEPHONE where no_individu = ? and tem_fax != 'O' order by tem_tel_principal desc,no_telephone");
				qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
					res.append("<telephone>");
					res.append("<numerotel>").append(Utils.xmlEscape(qry.getRs().getString("telephone"))).append("</numerotel>");
					res.append("</telephone>");
				}

				qry.setSql("select no_telephone fax from INDIVIDU_TELEPHONE where no_individu = ? and TEM_FAX='O'");
				qry.getStmt().setString(1, owner.getNoIndividu());
				qry.select();
				while (qry.getRs().next()){
					res.append("<fax>");
					res.append("<numerofax>").append(Utils.xmlEscape(qry.getRs().getString("fax"))).append("</numerofax>");
					res.append("</fax>");
				}
			}
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlTelephone() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlTelephone() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		}

		res.append("</coor_tel>");

		return res;
	}

	public StringBuffer getXmlBanque() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<banques>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select ib.c_banque, ib.c_guichet, ib.no_compte, ib.cle_rib, b.domiciliation from BANQUE b, INDIVIDU_BANQUE ib where ib.no_dossier_pers = ? and b.c_banque=ib.c_banque and b.c_guichet=ib.c_guichet");

				qry.getStmt().setString(1, owner.getNoIndividu());				
				qry.select();
				while (qry.getRs().next()){
					res.append("<banque>");
					res.append("<c_banque>").append(Utils.xmlEscape(qry.getRs().getString("c_banque"))).append("</c_banque>");
					res.append("<c_guichet>").append(Utils.xmlEscape(qry.getRs().getString("c_guichet"))).append("</c_guichet>");
					res.append("<no_compte>").append(Utils.xmlEscape(qry.getRs().getString("no_compte"))).append("</no_compte>");
					res.append("<cle_rib>").append(Utils.xmlEscape(qry.getRs().getString("cle_rib"))).append("</cle_rib>");
					res.append("<domiciliation>").append(Utils.xmlEscape(qry.getRs().getString("domiciliation"))).append("</domiciliation>");
					res.append("</banque>");
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlBanque() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlBanque() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		}

		res.append("</banques>");

		return res;
	}	

	public StringBuffer getXmlDiplome() throws FrameWorkException {
		StringBuffer res = new StringBuffer("<diplomes>");
		Query qry = null;
		boolean error = false;

		if (owner.getNoIndividu() != null) { // la personne connecte  un no_individu
			try {
				qry = Config.getInstance().getConnexionDefault();
				qry.setSql("select id.c_diplome, d.ll_diplome, id.specialite, nd.l_niveau_diplome, to_char(id.d_diplome,'YYYY') d_diplome, td.l_titulaire_diplome from INDIVIDU_DIPLOMES id, diplomes d, niveau_diplome nd, titulaire_diplome td where NO_INDIVIDU = ? and id.c_diplome=d.c_diplome and nd.c_niveau_diplome=d.c_niveau_diplome and td.c_titulaire_diplome=id.c_titulaire_diplome order by id.d_diplome");

				qry.getStmt().setString(1, owner.getNoIndividu());				
				qry.select();
				while (qry.getRs().next()){
					res.append("<diplome>");
					res.append("<c_diplome>").append(Utils.xmlEscape(qry.getRs().getString("c_diplome"))).append("</c_diplome>");
					res.append("<ll_diplome>").append(Utils.xmlEscape(qry.getRs().getString("ll_diplome"))).append("</ll_diplome>");
					res.append("<specialite>").append(Utils.xmlEscape(qry.getRs().getString("specialite"))).append("</specialite>");
					res.append("<l_niveau_diplome>").append(Utils.xmlEscape(qry.getRs().getString("l_niveau_diplome"))).append("</l_niveau_diplome>");
					res.append("<l_titulaire_diplome>").append(Utils.xmlEscape(qry.getRs().getString("l_titulaire_diplome"))).append("</l_titulaire_diplome>");
					res.append("<d_diplome>").append(Utils.xmlEscape(qry.getRs().getString("d_diplome"))).append("</d_diplome>");
					res.append("</diplome>");
				}
			} 
			catch (SQLException e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlDiplome() : Erreur SQL " + e);
		        }
				error = true;
			}
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("EtatCivil::getXmlDiplome() : Erreur SQL " + e);
		        }
				error = true;
			}
			finally {
				qry.close();
				if (error)
					throw new FrameWorkException();
			}
		}

		res.append("</diplomes>");

		return res;
	}	
}	
