﻿<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genIndividu.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="genIndividu">
         <xsl:with-param name="civilite" select="xml/individu/civilite" />

         <xsl:with-param name="dossier" select="xml/individu/dossier" />

			<xsl:with-param name="numen" select="xml/individu/numen" />

         <xsl:with-param name="nom_patro" select="xml/individu/nom_patro" />

         <xsl:with-param name="nom_usuel" select="xml/individu/nom_usuel" />

         <xsl:with-param name="prenom" select="xml/individu/prenom" />

         <xsl:with-param name="nouscontacter" select="xml/individu/nouscontacter" />

      </xsl:call-template>

      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>C A R R I E R E</b>

            <br />

            <br />
         </P>
      </div>

      <xsl:apply-templates select="xml/carrieres" />

   </xsl:template>

   <xsl:template match="carrieres">
      <xsl:if test="count(carriere) != 0">
         <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
            <TR class="uportal-background-light">
               <TD HEIGHT="30"> 
                  <P ALIGN="LEFT" class="uportal-channel-strong">Carrière</P>
               </TD>
            </TR>
         </TABLE>
         <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	      <TR>
	         <TD WIDTH="10%" class="uportal-channel-strong">Date d'effet</TD>
     	      <TD WIDTH="20%" class="uportal-channel-strong">Type d'accés</TD>
	         <TD WIDTH="30%" class="uportal-channel-strong">Corps</TD>
            <TD WIDTH="25%" class="uportal-channel-strong">Grade</TD>
	         <TD WIDTH="5%" class="uportal-channel-strong">Catégorie</TD>
	         <TD WIDTH="5%" class="uportal-channel-strong">Echelon</TD>
	         <TD WIDTH="5%" class="uportal-channel-strong">Indice</TD>
	      </TR>
	      <xsl:apply-templates select="carriere" />
	      </TABLE>
	   </xsl:if>
	   <xsl:if test="count(carriere) = 0">
         <p class="uportal-channel-strong" align="center">Pas de carrière en cours.</p>
	   </xsl:if>
   </xsl:template>

	<xsl:template match="carriere">
	 <TR valign="top">
		 <xsl:if test="position() mod 2 = 0">
		   <xsl:attribute name="class">uportal-background-highlight</xsl:attribute>
		 </xsl:if>
		 <xsl:if test="position() mod 2 = 1">
		   <xsl:attribute name="class">uportal-background-content</xsl:attribute>
		 </xsl:if>
	    <TD WIDTH="10%" class="uportal-channel-text"><a href="{$baseActionURL}?action=detailcarriere&amp;echelon={echelon}&amp;chevron={chevron}&amp;element={no_element}&amp;carriere={no_carriere}"><xsl:value-of select="date" /></a></TD>
	    <TD WIDTH="20%" class="uportal-channel-text"><xsl:value-of select="type" /></TD>
	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="corps" /></TD>
	    <TD WIDTH="25%" class="uportal-channel-text"><xsl:value-of select="grade" /></TD>
	    <TD WIDTH="5%" class="uportal-channel-text"><xsl:if test="categorie != 'null'"><xsl:value-of select="categorie" /></xsl:if></TD>
	    <TD WIDTH="5%" class="uportal-channel-text"><xsl:if test="echelon != 'null'"><xsl:value-of select="echelon" /></xsl:if></TD>
	    <TD WIDTH="5%" class="uportal-channel-text"><xsl:if test="indice != 'null'"><xsl:value-of select="indice" /></xsl:if></TD>
	 </TR>
	</xsl:template>
</xsl:stylesheet>

