<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:import href="genIndividu.xsl" />

   <xsl:import href="Liens.xsl" />

   <xsl:output method="html" indent="no" />

   <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>

   <xsl:param name="prefForm" />

   <xsl:param name="modeServant">none</xsl:param>
   <xsl:param name="mediaPath" />

   <xsl:template match="/">
      <xsl:call-template name="genIndividu">
         <xsl:with-param name="civilite" select="xml/individu/civilite" />

         <xsl:with-param name="dossier" select="xml/individu/dossier" />

			<xsl:with-param name="numen" select="xml/individu/numen" />

         <xsl:with-param name="nom_patro" select="xml/individu/nom_patro" />

         <xsl:with-param name="nom_usuel" select="xml/individu/nom_usuel" />

         <xsl:with-param name="prenom" select="xml/individu/prenom" />

         <xsl:with-param name="nouscontacter" select="xml/individu/nouscontacter" />

      </xsl:call-template>

      <xsl:call-template name="liensHorizontaux">
         <xsl:with-param name="annuaire" select="$modeServant" />
      </xsl:call-template>

      <div class="navigation-selected">
         <P ALIGN="CENTER" class="uportal-background-dark">
            <br />

            <b>C O N T R A T</b>

            <br />

            <br />
         </P>
      </div>

      <xsl:apply-templates select="xml/contrat" />
	  <xsl:apply-templates select="xml/occupations" />
	  <xsl:apply-templates select="xml/affectations" />
   </xsl:template>

   <xsl:template match="contrat">
         <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
            <TR class="uportal-background-light">
               <TD HEIGHT="30"> 
                  <P ALIGN="LEFT" class="uportal-channel-strong">Contrat</P>
               </TD>
            </TR>
         </TABLE>
         <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	       <TR>
	        <TD WIDTH="20%" class="uportal-channel-strong">N° du contrat</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="numero" /></TD>
     	    <TD WIDTH="20%" class="uportal-channel-strong">Type de contrat</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="typecontrat" /></TD>
           </TR>
           <TR>
	        <TD WIDTH="20%" class="uportal-channel-strong">N° de l'avenant</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="avenant" /></TD>
     	    <TD WIDTH="20%" class="uportal-channel-strong">Référence</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="reference" /></TD>
		   </TR>
           <TR>
	        <TD WIDTH="20%" class="uportal-channel-strong">Période</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="periode" /></TD>
     	    <TD WIDTH="20%" class="uportal-channel-strong">Date de signature</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="datesignature" /></TD>
		   </TR>
           <TR>
			<xsl:if test="fonction != ''">
		        <TD WIDTH="20%" class="uportal-channel-strong">Fonctions assurées</TD>
	     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="fonction" /></TD>
			</xsl:if>
			<xsl:if test="datefinexecution != ''">
	     	    <TD WIDTH="20%" class="uportal-channel-strong">Date de fin d'exécution</TD>
	     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="datefinexecution" /></TD>
			</xsl:if>
			<xsl:if test="datefinexecution = ''">
				<TD WIDTH="50%" COLSPAN="2" class="uportal-channel-strong"></TD>
			</xsl:if>
		   </TR>
           <TR>
	        <TD WIDTH="20%" class="uportal-channel-strong">Equivalent grade</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="grade" /></TD>
     	    <TD WIDTH="20%" class="uportal-channel-strong">Equivalent catégorie</TD>
     	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="categorie" /></TD>
		   </TR>
      	 </TABLE>
   </xsl:template>
   <xsl:template match="occupations">
	<xsl:if test="count(occupation) != 0">
      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Occupation</P>
            </TD>
         </TR>
	</TABLE>
	<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	 <TR>
	    <TD WIDTH="10%" class="uportal-channel-strong">N° du poste</TD>
	    <TD WIDTH="10%" class="uportal-channel-strong">N° national</TD>
	    <TD WIDTH="20%" class="uportal-channel-strong">Période</TD>
		<TD WIDTH="60%" class="uportal-channel-strong">Profil</TD>
	 </TR>
	<xsl:apply-templates select="occupation" />
	</TABLE>
	</xsl:if>
	</xsl:template>

	<xsl:template match="occupation">
	 <TR valign="top">
	    <TD WIDTH="10%" class="uportal-channel-text">
		<xsl:if test="poste != 'null'">
			<xsl:value-of select="poste" />
		</xsl:if>
		</TD>
	    <TD WIDTH="10%" class="uportal-channel-text">
		<xsl:if test="postenational != 'null'">
			<xsl:value-of select="postenational" />
		</xsl:if>
		</TD>
	    <TD WIDTH="20%" class="uportal-channel-text"><xsl:value-of select="periodeoccupation" /></TD>
		<TD WIDTH="60%" class="uportal-channel-text">
		<xsl:if test="profil != 'null'">
			<xsl:value-of select="profil" />
		</xsl:if>
		</TD>
	 </TR>
	</xsl:template>

   <xsl:template match="affectations">
	<xsl:if test="count(affectation) != 0"> 
     <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
         <TR class="uportal-background-light">
            <TD HEIGHT="30"> 
               <P ALIGN="LEFT" class="uportal-channel-strong">Affectation</P>
            </TD>
         </TR>
      </TABLE>

      <TABLE BORDER="0" CELLPADDING="0" CELLSPACING="0" WIDTH="100%">
	 <TR>
	    <TD WIDTH="30%" class="uportal-channel-strong">Structure</TD>
	    <TD WIDTH="25%" class="uportal-channel-strong">Période</TD>
	    <TD WIDTH="10%" class="uportal-channel-strong">N° du poste</TD>
	    <TD WIDTH="5%" class="uportal-channel-strong">Quotité</TD>
	    <TD WIDTH="30%" class="uportal-channel-strong">Adresse</TD>
	 </TR>
	<xsl:apply-templates select="affectation" />
	</TABLE>
	</xsl:if>
   </xsl:template>

   <xsl:template match="affectation">
	 <TR valign="top">
	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="structureaff" /></TD>
	    <TD WIDTH="25%" class="uportal-channel-text"><xsl:value-of select="periodeaff" /></TD>
	    <TD WIDTH="10%" class="uportal-channel-text"><xsl:value-of select="posteaff" /></TD>
	    <TD WIDTH="5%" class="uportal-channel-text"><xsl:value-of select="quotite" /> %</TD>
	    <TD WIDTH="30%" class="uportal-channel-text"><xsl:value-of select="rueaff" /><BR />
	    <xsl:value-of select="localiteaff" /><BR />
	    <xsl:value-of select="villeaff" />
	    </TD>
	 </TR>
	 <TR valign="top">
	 <TD WIDTH="100%" COLSPAN="5" HEIGHT="10">&#160;</TD>
	 </TR>
	</xsl:template>
</xsl:stylesheet>

