/*
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:jean-marc.Gullung@uhp-nancy.fr">Jean-Marc GULLUNG</a>
 * @version 1.0
 * 
 */
package org.esupportail.portal.utils.connectors_harpege;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMServices.PreparedStatement;
import org.jasig.portal.security.IPerson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author oziller
 *
 * Cette classe permet de retrouver le NO_INDIVIDU (identifiant Harpege) d'un individu
 * connaissant son login.
 * Cette classe utilise le fichier de proprits HarpegeConnector.xml
 * Cette classe est implmente sous forme d'un singleton.
 */
public class HarpegeConnector {

	protected static final Log log = LogFactory.getLog(HarpegeConnector.class);

	private static HarpegeConnector instance = null;
	private static String attributeName = null;
	// objet dsignant la classe retournant l'attribut de mapping connaissant la valeur du login
	private static IClassMapping res = null;

	/**
	 * Constructeur de la classe. Il est priv puisqu'il s'agit d'un singleton
	 * Initialise le nom de l'attribut dans lequel sera cach le NO_INDIVIDU
	 */
	private HarpegeConnector() {
		attributeName = getClass().getName() + ".NO_INDIVIDU";
	}

	/**
	 * Retourne le singleton de la classe HarpegeConnector.
	 * @return l'objet unique HarpegeConnector
	 */
	private static HarpegeConnector getInstance() {
		if (instance == null)
			instance = new HarpegeConnector();
		return instance;
	}

	/**
	 * Retourne un NO_INDIVIDU connaissant la valeur du login
	 * @param login login de la personne
	 * @return la valeur du NO_INDIVIDU pour le paramtre pass
	 * @throws ConnectorException
	 */
	public static String getNO_INDIVIDUFromLogin(String login) throws ConnectorException {
		String personAttribute = null;
		personAttribute = getPersonAttributeFromLogin(login);

		return getNO_INDIVIDU(personAttribute);
	}


	/**
	 * Retourne le personAttribute  utiliser pour faire le mapping connaissant la valeur du login 
	 * @param login login de la personne
	 * @return le personAttribute  utiliser pour faire le mapping
	 * @throws ConnectorException
	 */
	private static String getPersonAttributeFromLogin(String login) {
		String resLogin = null;

		if (HarpegeConnectorConfig.getInstance().getClassmapping() == null || 
		   (HarpegeConnectorConfig.getInstance().getClassmapping() != null && HarpegeConnectorConfig.getInstance().getClassmapping().equals(""))
		) {
		if (log.isDebugEnabled()){
			log.info("HarpegeConnector::getPersonAttributeFromLogin() : Valeur reue retourne");
		}

			resLogin = login;
		}	
		else {
			Class classmapping = null;
			Object classmappingObj = null;
			if (res == null) {
				// Instanciation de la classe charge de rcuprer le personne Attribute
				try {
					if (log.isDebugEnabled()){
						log.info("HarpegeConnector::getPersonAttributeFromLogin() : Tentative d'instanciation de la classmapping " + HarpegeConnectorConfig.getInstance().getClassmapping());
						log.info("HarpegeConnector::getPersonAttributeFromLogin() : Recherche classmapping ");
					}
					classmapping = Class.forName(HarpegeConnectorConfig.getInstance().getClassmapping());
					if (log.isDebugEnabled()){
						log.info("HarpegeConnector::getPersonAttributeFromLogin() : Recherche types params constructeur classmapping ");
					}
					Class[] types = {};
					if (log.isDebugEnabled()){
						log.info("HarpegeConnector::getPersonAttributeFromLogin() : Recherche constructeur ");
					}
					Constructor cons = classmapping.getConstructor(types);
					Object[] params = {};
					if (log.isDebugEnabled()){
						log.info("HarpegeConnector::getPersonAttributeFromLogin() : Utilisation constructeur ");
					}
					classmappingObj = cons.newInstance(params);
					res = (IClassMapping)classmappingObj;
					if (log.isDebugEnabled()){
						log.info("HarpegeConnector::getPersonAttributeFromLogin() : Instanciation de la sub-channel " + HarpegeConnectorConfig.getInstance().getClassmapping() + " russie !");
					}
				}
				catch (Exception e) {
					res = null;
					if (log.isDebugEnabled()){
						log.error("HarpegeConnector::getPersonAttributeFromLogin() : Echec de l'instanciation de la classmapping :  " + HarpegeConnectorConfig.getInstance().getClassmapping());
					}
				}
			}
			if (log.isDebugEnabled()){
				log.info("Appel de la mthode de rcupration du personAtribute ");
			}
			resLogin = res.getPersonAttributeFromLogin(login);
		}
		return resLogin;
	}


	/**
	 * Retourne un NO_INDIVIDU connaissant la valeur de l'attribut qui nous permet de faire le mapping.
	 * @param personAttributeValue la valeur du paramtre de la requte sql de mapping
	 * @return la valeur du NO_INDIVIDU pour le paramtre pass
	 * @throws ConnectorException
	 */
	public static String getNO_INDIVIDU(String personAttributeValue) throws ConnectorException {
		Connection con = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		String res = null;

		// cas particuler ou le sqlmapping est null ou vide = cela veut dire qu'on retourne directement
		// l'attribut pass en paramtre
		if (HarpegeConnectorConfig.getInstance().getSqlMapping() == null)
			return personAttributeValue;
		else
			if (HarpegeConnectorConfig.getInstance().getSqlMapping().equals(""))
				return personAttributeValue;
			else
			// sinon interrogation de la base de donnes		
			try {
				try {
					con =
						RDBMServices.getConnection(
							HarpegeConnectorConfig.getInstance().getPool());
					stmt =
						new RDBMServices.PreparedStatement(
							con,
							HarpegeConnectorConfig.getInstance().getSqlMapping());
					stmt.clearParameters();
					stmt.setString(1, personAttributeValue);
					rs = stmt.executeQuery();
					if (rs.next())
						res = rs.getString("NO_INDIVIDU");
					else
					  throw new ConnectorException("Impossible de trouver un NO_INDIVIDU pour la valeur " + personAttributeValue);
				}
				finally {
					if (rs != null)
						rs.close();
					if (stmt != null)
						stmt.close();
					if (con != null)
						con.close();
				}
			} 
			catch (Exception e) {
				// echec de la rcupration du NO_INDIVID
				throw new ConnectorException("Erreur sur la requte de mapping Harpege : " +
				  e.toString()); 
			}
		return res;
	}

	/**
	 * Retourne le NO_INDIVIDU associ  une personne (reprsente par un objet IPerson).
	 * Le rsultat est mis en cache pour la personne ce qui vite ensuite de relancer des requtes SQL
	 * @param person la personne pour laquelle on recherche le NO_INDIVIDU
	 * @return la valeur du NO_INDIVIDU pour la personne
	 * @throws ConnectorException
	 */
	public static String getNO_INDIVIDU(IPerson person) throws ConnectorException {
		String res = null;

		// recherche de l'attribut NO_INDIVIDU en cache
		res = (String)person.getAttribute(getInstance().getAttributeName());
		// si l'attribut NO_INDIVIDU existe dj pour la personne 
		if ( res != null)
			return res;
	   // sinon on recherche sa valeur et on l'enregistre
      // recherche de l'attribut de mapping pour la personne en cours
	   String attributeValue = (String)person.getAttribute(HarpegeConnectorConfig.getInstance().getPersonAttribute());
	     // cet attribut doit tre valu
	   if (attributeValue == null)
	   	throw new ConnectorException("L'attribut " + HarpegeConnectorConfig.getInstance().getPersonAttribute() + " n'est pas valu pour la personne");
	   	 // recherche de la valeur du NO_INDIVIDU connaissant la valeur de l'attribut de mapping
	   res = getNO_INDIVIDU(attributeValue);
	   // enregistrement du rsultat dans le cache
	   person.setAttribute(getInstance().getAttributeName(),res);
	   // retour du NO_INDIVIDU
	   return res;
	}

	/**
	 * @return le nom de l'attribut d'une personne dans lequel on va stocker le NO_INDIVIDU
	 */
	public String getAttributeName() {
		return attributeName;
	}
}
