/*
 * (c)Copyright <a href="www.esup-portail.org">ESup-Portail 2004</a>
 * @author <a href="mailto:jean-marc.gullung@uhp-nancy.fr">Jean-Marc GULLUNG</a>
 * @version 1.0
 */ 
package org.esupportail.portal.utils.connectors_harpege;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Jean-Marc GULLUNG
 *
 * Cette classe a pour objet de lire et maintenir un accs vers les proprits du connecteur Harpege
 * 
 */
public class HarpegeConnectorConfig
{ 
	protected static final Log log = LogFactory.getLog(HarpegeConnectorConfig.class);

	//dclaration des variables de la classe
		// singleton de la classe
	private static HarpegeConnectorConfig singleton = null;
	   	// pool de connexion  utiliser 
	private String pool = null;
		// attribut de la personne qui sert  faire le mapping
	private String personattribute = null;
		// Requete qui nous donne le COD_IND connaissant la valeur de l'attribut de mapping
	private String sqlmapping = null;
		// Classe qui nous donne l'attribut de mapping connaissant la valeur du login
	private String classmapping= null;
		// infos sur le compte de test
	private String loginTest = null;
	private String codIndTest = null;

	/**
	 * Constructeur de la classe
	 * Il lit le fichier de configuration et en extrait les paramtres du connecteur Harpege.
	 *
	 */
	public HarpegeConnectorConfig() {	
		//	Cration d'une instance Digester 
		Digester dig = new Digester();
		//On rend l'objet disponible  la manipulation en le mettant en haut de la pile
		dig.push(this);
		//Chaque fois que "config" sera lu  la lecture du fichier de config on fera appelle  la mthode addRoot() avec 4 paramtres
		dig.addCallMethod("config","addRoot",4);
		//Premier paramtre de la mthode addRoot()
		dig.addCallParam("config/pool",0);
		//Deuxime paramtre de la mthode addRoot()
		dig.addCallParam("config/personattribute",1);
		//Troisime paramtre de la mthode addRoot()
		dig.addCallParam("config/sqlmapping",2);
		dig.addCallParam("config/classmapping",3);
		//	Emplacement du fichier de config  parser  partir du rpertoire classes
		URL resourceURL =  HarpegeConnectorConfig.class.getResource("/properties/channels/org_esup/connectors_harpege/HarpegeConnector.xml");
		if (resourceURL != null){
			try {
				// On parse le fichier dont le chemin est pass en paramtre
				dig.parse(new InputSource(resourceURL.toExternalForm()));
			 }
			catch (IOException e) {
				if (log.isDebugEnabled()){
		        	log.error("Config::Config() : ERREUR : Impossible d'ouvrir le fichier de config HarpegeConnector.xml\n" + e.toString());
		        }
				 }
			catch (SAXException e) {
				if (log.isDebugEnabled()){
		        	log.error("Config::Config() : ERREUR : SAXException :\n" + e.toString());
		        }
				 } 
			catch (Exception e) {
				if (log.isDebugEnabled()){
		        	log.error("Config::Config() : ERREUR : de lecture du fichier de config\n" + e.toString());
		        }
			}
		}
		else{
			if (log.isDebugEnabled()){
	        	log.error("Config::Config() : ERREUR : HarpegeConnector n'existe pas.\n");
	        }
		}	
	}

	/**
	* Methode ncessaire au digester.
	* 
	* @param pool
	* @param personAttribute
	* @param sqlMapping
	* @param classMapping
	* 
	*/
	public void addRoot(String pool, String personattribute,String sqlmapping, String classmapping) throws ConnectorException  {
		this.pool = pool;
		this.personattribute = personattribute;
		this.sqlmapping = sqlmapping;
		this.classmapping = classmapping;
		// Vrifications sur la validit de la configuration
		if (this.personattribute == null)
		  throw new ConnectorException("Connecteur Harpegee : l'attribut de la personne n'est pas prcis");
		if ((this.pool != null) && (this.sqlmapping == null))
			throw new ConnectorException("Connecteur Harpegee : il faut prciser une requte de mapping sql");
		if ((this.pool == null) && (this.sqlmapping != null))
			throw new ConnectorException("Connecteur Harpege : il faut prciser le pool sur lequel excuter la requte de mapping sql");
	}

	/**
	* Accs  l'occurence du singleton.
	* 
	* @return Config Instance
	* @throws IOException
	* @throws JspException
	*/
	public static HarpegeConnectorConfig getInstance() {

		if (singleton == null) {
			 singleton = new HarpegeConnectorConfig();
		 	}
		return singleton;
	}

	/**
	 * @return
	 */
	public String getPersonAttribute() {
		return personattribute;
	}

	/**
	 * @return
	 */
	public String getPool() {
		return pool;
	}

	/**
	 * @return
	 */
	public String getSqlMapping() {
		return sqlmapping;
	}

	/**
	 * @param string
	 */
	public void setPersonAttribute(String string) {
		personattribute = string;
	}

	/**
	 * @param string
	 */
	public void setPool(String string) {
		pool = string;
	}

	/**
	 * @param string
	 */
	public void setSqlMapping(String string) {
		sqlmapping = string;
	}

	/**
	 * @return Returns the classmapping.
	 */
	public String getClassmapping() {
		return classmapping;
	}
	/**
	 * @param classmapping The classmapping to set.
	 */
	public void setClassmapping(String classmapping) {
		this.classmapping = classmapping;
	}
}

