/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.encryption.PDFEncryption;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;

public class DocumentEncryption {
    private static final COSName ENCRYPT = COSName.getPDFName("Encrypt");
    private PDDocument pdDocument = null;
    private COSDocument document = null;
    private byte[] encryptionKey = null;
    private PDFEncryption encryption = new PDFEncryption();
    private Set objects = new HashSet();

    public DocumentEncryption(PDDocument doc) {
        this.pdDocument = doc;
        this.document = doc.getDocument();
    }

    public DocumentEncryption(COSDocument doc) {
        this.pdDocument = new PDDocument(doc);
        this.document = doc;
    }

    public void encryptDocument(String ownerPassword, String userPassword) throws CryptographyException, IOException {
        if (ownerPassword == null) {
            ownerPassword = "";
        }
        if (userPassword == null) {
            userPassword = "";
        }
        PDStandardEncryption encParameters = (PDStandardEncryption)this.pdDocument.getEncryptionDictionary();
        int permissionInt = encParameters.getPermissions();
        COSArray idArray = this.document.getDocumentID();
        if (idArray == null || idArray.size() < 2) {
            idArray = new COSArray();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                BigInteger time = BigInteger.valueOf(System.currentTimeMillis());
                md.update(time.toByteArray());
                md.update(ownerPassword.getBytes());
                md.update(userPassword.getBytes());
                md.update(this.document.toString().getBytes());
                byte[] id = md.digest(this.toString().getBytes());
                COSString idString = new COSString();
                idString.append(id);
                idArray.add(idString);
                idArray.add(idString);
                this.document.setDocumentID(idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptographyException(e);
            }
        }
        COSString id = (COSString)idArray.get(0);
        this.encryption = new PDFEncryption();
        byte[] o = this.encryption.computeOwnerPassword(ownerPassword.getBytes("ISO-8859-1"), userPassword.getBytes("ISO-8859-1"), 2, 5);
        byte[] u = this.encryption.computeUserPassword(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), 2, 5);
        this.encryptionKey = this.encryption.computeEncryptedKey(userPassword.getBytes("ISO-8859-1"), o, permissionInt, id.getBytes(), 2, 5);
        encParameters.setOwnerKey(o);
        encParameters.setUserKey(u);
        COSDictionary trailer = this.document.getTrailer();
        List allObjects = this.document.getObjects();
        Iterator objectIter = allObjects.iterator();
        while (objectIter.hasNext()) {
            this.decryptObject((COSObject)objectIter.next());
        }
        this.document.setEncryptionDictionary(encParameters.getCOSDictionary());
    }

    public void decryptDocument(String password) throws CryptographyException, IOException, InvalidPasswordException {
        if (password == null) {
            password = "";
        }
        long start = System.currentTimeMillis();
        COSDictionary trailer = this.document.getTrailer();
        PDStandardEncryption encParameters = (PDStandardEncryption)this.pdDocument.getEncryptionDictionary();
        int permissions = encParameters.getPermissions();
        int revision = encParameters.getRevision();
        int length = encParameters.getLength() / 8;
        COSString id = (COSString)this.document.getDocumentID().get(0);
        byte[] u = encParameters.getUserKey();
        byte[] o = encParameters.getOwnerKey();
        boolean isUserPassword = this.encryption.isUserPassword(password.getBytes(), u, o, permissions, id.getBytes(), revision, length);
        boolean isOwnerPassword = this.encryption.isOwnerPassword(password.getBytes(), u, o, permissions, id.getBytes(), revision, length);
        if (isUserPassword) {
            this.encryptionKey = this.encryption.computeEncryptedKey(password.getBytes(), o, permissions, id.getBytes(), revision, length);
        } else if (isOwnerPassword) {
            byte[] computedUserPassword = this.encryption.getUserPassword(password.getBytes(), o, revision, length);
            this.encryptionKey = this.encryption.computeEncryptedKey(computedUserPassword, o, permissions, id.getBytes(), revision, length);
        } else {
            throw new InvalidPasswordException("Error: The supplied password does not match either the owner or user password in the document.");
        }
        List allObjects = this.document.getObjects();
        Iterator objectIter = allObjects.iterator();
        while (objectIter.hasNext()) {
            this.decryptObject((COSObject)objectIter.next());
        }
        this.document.setEncryptionDictionary(null);
    }

    private static void printHexString(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            int nextByte = (data[i] + 256) % 256;
            String hexString = Integer.toHexString(nextByte);
            if (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            System.out.print(hexString);
            if (i != 0 && (i + 1) % 2 == 0) {
                System.out.print(" ");
                continue;
            }
            if (i == 0 || i % 20 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private void decryptObject(COSObject object) throws CryptographyException, IOException {
        long objNum = object.getObjectNumber().intValue();
        long genNum = object.getGenerationNumber().intValue();
        COSBase base = object.getObject();
        this.decrypt(base, objNum, genNum);
    }

    private void decrypt(Object obj, long objNum, long genNum) throws CryptographyException, IOException {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
            if (obj instanceof COSString) {
                this.decryptString((COSString)obj, objNum, genNum);
            } else if (obj instanceof COSDictionary) {
                this.decryptDictionary((COSDictionary)obj, objNum, genNum);
            } else if (obj instanceof COSStream) {
                this.decryptStream((COSStream)obj, objNum, genNum);
            } else if (obj instanceof COSArray) {
                this.decryptArray((COSArray)obj, objNum, genNum);
            }
        }
    }

    private void decryptStream(COSStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        this.decryptDictionary(stream.getDictionary(), objNum, genNum);
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, encryptedStream, stream.createFilteredStream());
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws CryptographyException, IOException {
        Iterator values = dictionary.getValues().iterator();
        while (values.hasNext()) {
            this.decrypt(values.next(), objNum, genNum);
        }
    }

    private void decryptString(COSString string, long objNum, long genNum) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, data, buffer);
        string.reset();
        string.append(buffer.toByteArray());
    }

    private void decryptArray(COSArray array, long objNum, long genNum) throws CryptographyException, IOException {
        for (int i = 0; i < array.size(); ++i) {
            this.decrypt(array.get(i), objNum, genNum);
        }
    }
}

