/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDChoiceButton;

public class PDCheckbox
extends PDChoiceButton {
    private static final COSName KEY = COSName.getPDFName("AS");
    private static final COSName OFF_VALUE = COSName.getPDFName("Off");
    private COSName value;

    public PDCheckbox(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
        COSDictionary ap = (COSDictionary)field.getDictionaryObject(COSName.getPDFName("AP"));
        if (ap != null) {
            COSBase n = ap.getDictionaryObject(COSName.getPDFName("N"));
            if (n instanceof COSDictionary) {
                List li = ((COSDictionary)n).keyList();
                this.value = (COSName)li.get(0);
            }
        } else {
            this.value = (COSName)this.getDictionary().getDictionaryObject("V");
        }
    }

    public void check() {
        this.getDictionary().setItem(KEY, (COSBase)this.value);
    }

    public void unCheck() {
        this.getDictionary().setItem(KEY, (COSBase)OFF_VALUE);
    }

    public void setValue(String newValue) {
        this.getDictionary().setName("V", newValue);
        if (newValue == null) {
            this.getDictionary().setItem(KEY, (COSBase)OFF_VALUE);
        } else {
            this.getDictionary().setName(KEY, newValue);
        }
    }

    public String getValue() throws IOException {
        return this.getDictionary().getNameAsString("V");
    }
}

