/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import java.util.Stack;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

abstract class BinaryOperator
extends Operator
implements ParsedThing {
    public int read(byte[] data, int pos) {
        return 0;
    }

    public void getOperands(Stack s) {
        ParseItem o1 = (ParseItem)s.pop();
        ParseItem o2 = (ParseItem)s.pop();
        this.add(o1);
        this.add(o2);
    }

    public void getString(StringBuffer buf) {
        ParseItem[] operands = this.getOperands();
        operands[1].getString(buf);
        buf.append(this.getSymbol());
        operands[0].getString(buf);
    }

    public void adjustRelativeCellReferences(int colAdjust, int rowAdjust) {
        ParseItem[] operands = this.getOperands();
        operands[1].adjustRelativeCellReferences(colAdjust, rowAdjust);
        operands[0].adjustRelativeCellReferences(colAdjust, rowAdjust);
    }

    byte[] getBytes() {
        ParseItem[] operands = this.getOperands();
        byte[] data = new byte[]{};
        for (int i = operands.length - 1; i >= 0; --i) {
            byte[] opdata = operands[i].getBytes();
            byte[] newdata = new byte[data.length + opdata.length];
            System.arraycopy(data, 0, newdata, 0, data.length);
            System.arraycopy(opdata, 0, newdata, data.length, opdata.length);
            data = newdata;
        }
        byte[] newdata = new byte[data.length + 1];
        System.arraycopy(data, 0, newdata, 0, data.length);
        newdata[data.length] = this.getToken().getCode();
        return newdata;
    }

    abstract String getSymbol();

    abstract Token getToken();
}

