/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.Cell;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class CellReference
extends Operand
implements ParsedThing {
    private boolean columnRelative;
    private boolean rowRelative;
    private int column;
    private int row;
    private Cell relativeTo;

    public CellReference(Cell rt) {
        this.relativeTo = rt;
    }

    public CellReference() {
    }

    public CellReference(String s) {
        this.column = CellReferenceHelper.getColumn(s);
        this.row = CellReferenceHelper.getRow(s);
        this.columnRelative = CellReferenceHelper.isColumnRelative(s);
        this.rowRelative = CellReferenceHelper.isRowRelative(s);
    }

    public int read(byte[] data, int pos) {
        this.row = IntegerHelper.getInt(data[pos], data[pos + 1]);
        int columnMask = IntegerHelper.getInt(data[pos + 2], data[pos + 3]);
        this.column = columnMask & 0xFF;
        this.columnRelative = (columnMask & 0x4000) != 0;
        this.rowRelative = (columnMask & 0x8000) != 0;
        return 4;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void getString(StringBuffer buf) {
        CellReferenceHelper.getCellReference(this.column, this.row, buf);
    }

    byte[] getBytes() {
        byte[] data = new byte[5];
        data[0] = Token.REF.getCode();
        IntegerHelper.getTwoBytes(this.row, data, 1);
        int grcol = this.column;
        if (this.rowRelative) {
            grcol |= 0x8000;
        }
        if (this.columnRelative) {
            grcol |= 0x4000;
        }
        IntegerHelper.getTwoBytes(grcol, data, 3);
        return data;
    }

    public void adjustRelativeCellReferences(int colAdjust, int rowAdjust) {
        if (this.columnRelative) {
            this.column += colAdjust;
        }
        if (this.rowRelative) {
            this.row += rowAdjust;
        }
    }
}

