/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;

class PropertySetsReader {
    private BufferedWriter writer;
    private CompoundFile compoundFile;

    public PropertySetsReader(File file, OutputStream os) throws IOException, BiffException {
        int bytesRead;
        this.writer = new BufferedWriter(new OutputStreamWriter(os));
        FileInputStream fis = new FileInputStream(file);
        int initialFileSize = 0x100000;
        int arrayGrowSize = 0x100000;
        byte[] d = new byte[initialFileSize];
        int pos = bytesRead = fis.read(d);
        while (bytesRead != -1) {
            if (pos >= d.length) {
                byte[] newArray = new byte[d.length + arrayGrowSize];
                System.arraycopy(d, 0, newArray, 0, d.length);
                d = newArray;
            }
            bytesRead = fis.read(d, pos, d.length - pos);
            pos += bytesRead;
        }
        bytesRead = pos + 1;
        this.compoundFile = new CompoundFile(d);
        fis.close();
        this.displaySets();
    }

    void displaySets() throws IOException {
        String[] sets = this.compoundFile.getPropertySetNames();
        for (int i = 0; i < sets.length; ++i) {
            this.writer.write(sets[i]);
            this.writer.newLine();
        }
        this.writer.flush();
        this.writer.close();
    }
}

