/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 * 
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 * 
 * This program is a free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.ThreadAction;

import java.io.*;
import org.apache.lucene.index.Term;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.Lucene.LuceneActions;


/**
 * Classe utilisant des threads pour mettre  jour des documents dans l'index.
 * <br/><br/>
 * Class using threads for updating documents in index.
 * 
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
public class ThreadIndexUpdating
    extends Thread {

  private String dir = "";
  private String field = "";
  private String content = "";
  private String fileToIndex = "";
  private String config = "";
  private Term term = null;
  private boolean populated = false;
  private boolean populatedWithTerm = false;

  public ThreadIndexUpdating(String dir, String field, String content,
                             String fileToIndex, String config) {
    this.dir = dir;
    this.field = field;
    this.content = content;
    this.fileToIndex = fileToIndex;
    this.config = config;
    populated = true;
  }

  public ThreadIndexUpdating(String dir, Term term, String fileToIndex,
                             String config) {
    this.dir = dir;
    this.term = term;
    this.fileToIndex = fileToIndex;
    this.config = config;
    boolean populatedWithTerm = true;
  }

  public void run() {
    if (populated == true) {

      try {
        LuceneActions.getSingletonInstance().updateDoc(dir, field, content,
            fileToIndex, config);
        try {
          Thread.sleep(1000);
        }
        catch (InterruptedException ex) {
          ex.printStackTrace();
        }

      }
      catch (LiusException e) {
        e.printStackTrace();
      }
      catch (IOException e) {
        e.printStackTrace();
      }
    }
    else if (populatedWithTerm == true) {

      try {
        LuceneActions.getSingletonInstance().updateDoc(dir, term, fileToIndex,
            config);
        try {
          Thread.sleep(1000);
        }
        catch (InterruptedException ex) {
          ex.printStackTrace();
        }

      }
      catch (LiusException e) {
        e.printStackTrace();
      }
      catch (IOException e) {
        e.printStackTrace();
      }

    }

  }

}