/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.main.samples;

import java.util.List;
import java.util.ArrayList;
import java.io.File;
import java.util.StringTokenizer;
import java.io.*;

import ca.ulaval.bibl.lius.Lucene.LuceneActions;
import ca.ulaval.bibl.lius.main.beans.Book;
import ca.ulaval.bibl.lius.main.beans.Personne;


/**
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */

public class IndexingJavaBeans {
  public IndexingJavaBeans() {
  }

  public static void main(String[] args) {

    String sep = File.separator;
    StringTokenizer st = new StringTokenizer(System.getProperty(
        "java.class.path"), File.pathSeparator);
    File classDir = new File(st.nextToken());

    String indexDir = classDir.getParent() + sep + "luceneIndex";
    String liusConfig = classDir.getParent() + sep + "Config" + sep +
        "liusBeansConfig.xml";

    //Liste des beans  indexer
    List beans = new ArrayList();

    //Bean Book
    Book b = new Book();
    b.setTitle("Lucene index update and search");
    b.setCreator("Rida Benjelloun");
    beans.add(b);

    //Bean Personne
    Personne p = new Personne();
    p.setNom("Benjelloun");
    p.setPrenom("Miya");
    p.setAdresse("3061 des chatelets");
    beans.add(p);

    // Indexation
    System.out.println("@@@@@@ Indexation : ");
    try {
    //Mthode utilise pour des applications Web
     LuceneActions.getSingletonInstance().deleteAllDocuments(indexDir);
     LuceneActions.getSingletonInstance().indexJavaBeans(beans, indexDir,
          liusConfig);
    }
    catch (IOException ex) {
      ex.printStackTrace();
    }



  }
}