package org.injac.indexing.indexing;

import org.apache.webdav.lib.WebdavFile;
import org.injac.indexing.exceptions.ConnectionException;
import org.injac.indexing.util.WebdavConnection;

public class Browser {
	/**
	 * context path
	 */
	protected String contextPath;
	/**
	 * WEBDAV Connection
	 */
	protected WebdavConnection webdavConnection;
	/**
	 * Indexing class
	 */
	protected Indexing indexing; 
	/**
	 * counters
	 */
	protected  int FileCount = 0, DirectoryCount = 0;

	public Browser(String contextPath, WebdavConnection webdavConnection){
		this.contextPath = contextPath;
		this.webdavConnection = webdavConnection;

	}
	/**
	 * Main indexing cycle life algorythm 
	 * @param root
	 * @param indexName
	 * @param mdMode
	 * @return
	 * @throws ConnectionException
	 */
	public int indexAll(WebdavFile root, String indexName, int mdMode) throws ConnectionException{
		resetCounts();
		indexing = new Indexing(indexName,contextPath, mdMode, webdavConnection);
		int result = browse(root,indexName,mdMode);
		indexing.closeReport();
		return result;
	}
	/**
	 * generic method to browse and index. Extented classes must implement this method.
	 * @param root
	 * @param indexName
	 * @param mdMode
	 * @return
	 * @throws ConnectionException
	 */
	public int browse(WebdavFile root, String indexName, int mdMode) throws ConnectionException{
		return 0;
	}
	
	/**
	 * incremente le FileCount
	 */
	protected  void incFileCount() {
		FileCount++;
		}
	
	/**
	 * incremente le DirectoryCount
	 */
	protected  void incDirectoryCount() {
		DirectoryCount++;
		}

	protected  int getFileCount(){
		return FileCount;
		}

	protected  int getDirectoryCount(){
		return DirectoryCount;
		}
	
	protected  void resetCounts(){
		FileCount = 0;
		DirectoryCount = 0;
		}

}
