/*
 * Created on 11 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.indexing.indexing;

import java.io.IOException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavFile;
import org.injac.indexing.exceptions.ConnectionException;
import org.injac.indexing.util.WebdavConnection;

/**
 * Classe permetant de parcourir un arbre des repertoires
 * WebDav et qui appele la founction d'indexation 
 * Indexing.index(WebdavFile) pour chaque fichier
 * indexable
 * @author marius
 */
public class CreateBrowser extends Browser {
	static Logger logger = Logger.getLogger("INJAC_INDEX");

	public CreateBrowser(String contextPath, WebdavConnection webdavConnection){
		super(contextPath, webdavConnection);
	}
	/**
	 * Fonction principale pour parcourir l'arborescence(rcursive)
	 * @param root
	 * @throws ConnectionException
	 */
	
	public int browse(WebdavFile root, String indexName, int mdMode) throws ConnectionException{
		try{
			if(!root.exists()){
				throw new ConnectionException();
			}
		}
		catch(org.apache.webdav.lib.WebdavException we){
			throw new ConnectionException();
		}
			
		String[] continut = root.list();
		for(int i=0; i<continut.length; i++){
			logger.debug(continut[i]);
			try{
				HttpURL hrl = new HttpURL(continut[i]);
				hrl.setUserinfo(root.getUser(),	root.getPass());
				WebdavFile wf = new WebdavFile(hrl);
				if(wf.isDirectory()){
					browse(wf, indexName, mdMode);
					incDirectoryCount();
				}
				else if(indexing.index(wf,indexName)){
					incFileCount();
				}
	        
			}
			catch(HttpException he)
	        {
	        	logger.error("HttpException : "+he.getLocalizedMessage());
	        }
	        catch(IOException ioe)
	        {
	        	logger.error("IOException : "+ioe.getLocalizedMessage());
	        } 
	        
		}
		return FileCount;
	}
	
}
