package org.injac.indexing.indexing;

import java.io.File;
import java.io.IOException;

import javax.servlet.http.HttpServlet;

import org.apache.log4j.Logger;
import org.injac.indexing.util.FileTools;
import org.injac.indexing.util.MetadataMode;

public class GenericIndexingServlet extends HttpServlet {
	static Logger logger = Logger.getLogger("INJAC_INDEX");
	protected String indexPath;
	public GenericIndexingServlet() {
		super();
		// TODO Auto-generated constructor stub
	}
	protected int extractMode(String mode){
		int result= MetadataMode.NONE;
		if(mode != null)
		{
			try {
				result= Integer.parseInt(mode);
				
			}catch(Exception e){
				logger.error("bad metadata indexing mode : "+mode + " (no metadata will be indexed)");
			}
		}
		return result;			
	}
	/**
	 * Create index directory and Temp directory for uploaded document 
	 * @param indexName
	 * @param create if set to true, empty index directory
	 * @return
	 */
	protected File createFiles(String indexName, boolean create){
		File index = new File(indexPath + "/"+ indexName);
		if (!index.exists()) {
			if(index.mkdirs()){
				logger.debug("creating "+indexPath + "/"+ indexName+" for new index");
			}
		}else if(create==true)
		{
			// clear dir
			FileTools.clearDir(index);
		}
		
		File temp = new File(indexPath+"/Temp/"+indexName);
		if(!temp.exists()){
			temp.mkdirs();
		}else {
			FileTools.clearDir(temp);
		}
		return temp;
	}
	protected boolean deleteTemps(File temp){
		String rootTemp = temp.getAbsolutePath().substring(0, temp.getAbsolutePath().lastIndexOf("Temp")+4);
		
		File rootTempFile = new File(rootTemp);
		return FileTools.deleteDir(rootTempFile);
	}
}
