package org.injac.indexing.indexing;

import java.io.File;
import java.io.IOException;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Removing {
	public static boolean removeFromIndex(String indexPath, String indexName, String url){
		File index = new File(indexPath+ "/" + indexName);
		return delete(index, url);
		
	}
	private static boolean delete(File indexDir, String url){
		try{
			Directory directory = FSDirectory.getDirectory(indexDir, false);
			IndexReader reader = IndexReader.open(directory);
			String adress = null;
			String name = null;
			int n = reader.numDocs();
			for(int i = 0 ;i < n ;i++){
				if(!reader.isDeleted(i)){
					Document d = reader.document(i);
					adress = d.get("url");
					name = d.get("name");
					adress = adress + "/" + name;
					if(adress.equals(url)){
						//Enumeration e = d.fields();
						reader.delete(i);
						reader.close();
						directory.close();
						return true;
						}
					}
				else{
					n++;
					}
				}
			reader.close();
			directory.close();
		}
		catch(IOException ioe){
			ioe.printStackTrace();
		}
		return false;
	}
}
