/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html;

import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Stack;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentScanner;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLComponent;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLEntities;
import org.cyberneko.html.HTMLErrorReporter;
import org.cyberneko.html.HTMLEventInfo;

public class HTMLScanner
implements XMLDocumentScanner,
XMLLocator,
HTMLComponent {
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    public static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    public static final String NOTIFY_XML_BUILTIN_REFS = "http://apache.org/xml/features/scanner/notify-builtin-refs";
    public static final String NOTIFY_HTML_BUILTIN_REFS = "http://cyberneko.org/html/features/scanner/notify-builtin-refs";
    public static final String STRIP_COMMENT_DELIMITERS = "http://cyberneko.org/html/features/scanner/script/strip-comment-delims";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://cyberneko.org/html/features/augmentations", "http://cyberneko.org/html/features/report-errors", "http://apache.org/xml/features/scanner/notify-char-refs", "http://apache.org/xml/features/scanner/notify-builtin-refs", "http://cyberneko.org/html/features/scanner/notify-builtin-refs", "http://cyberneko.org/html/features/scanner/script/strip-comment-delims"};
    private static final Boolean[] RECOGNIZED_FEATURES_DEFAULTS = new Boolean[]{null, null, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String DEFAULT_ENCODING = "http://cyberneko.org/html/properties/default-encoding";
    protected static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/names/attrs", "http://cyberneko.org/html/properties/default-encoding", "http://cyberneko.org/html/properties/error-reporter"};
    private static final Object[] RECOGNIZED_PROPERTIES_DEFAULTS = new Object[]{null, null, "Windows-1252", null};
    protected static final short STATE_CONTENT = 0;
    protected static final short STATE_MARKUP_BRACKET = 1;
    protected static final short STATE_START_DOCUMENT = 10;
    protected static final short STATE_END_DOCUMENT = 11;
    protected static final short NAMES_NO_CHANGE = 0;
    protected static final short NAMES_MATCH = 0;
    protected static final short NAMES_UPPERCASE = 1;
    protected static final short NAMES_LOWERCASE = 2;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final boolean DEBUG_SCANNER = false;
    private static final boolean DEBUG_SCANNER_STATE = false;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_CHARSET = false;
    protected static final boolean DEBUG_CALLBACKS = false;
    protected boolean fAugmentations;
    protected boolean fReportErrors;
    protected boolean fNotifyCharRefs;
    protected boolean fNotifyXmlBuiltinRefs;
    protected boolean fNotifyHtmlBuiltinRefs;
    protected boolean fStripCommentDelims;
    protected short fNamesElems;
    protected short fNamesAttrs;
    protected String fDefaultIANAEncoding;
    protected HTMLErrorReporter fErrorReporter;
    protected int fBeginLineNumber;
    protected int fBeginColumnNumber;
    protected int fEndLineNumber;
    protected int fEndColumnNumber;
    protected PlaybackInputStream fByteStream;
    protected CurrentEntity fCurrentEntity;
    protected final Stack fCurrentEntityStack = new Stack();
    protected Scanner fScanner;
    protected short fScannerState;
    protected XMLDocumentHandler fDocumentHandler;
    protected String fIANAEncoding;
    protected String fJavaEncoding;
    protected int fElementCount;
    protected int fElementDepth;
    protected Scanner fContentScanner = new ContentScanner();
    protected SpecialScanner fSpecialScanner = new SpecialScanner();
    protected final XMLString fString = new XMLString();
    protected final XMLStringBuffer fStringBuffer = new XMLStringBuffer(1024);
    private final XMLStringBuffer fStringBuffer2 = new XMLStringBuffer(1024);
    private final XMLStringBuffer fNonNormAttr = new XMLStringBuffer(128);
    private final Augmentations fInfosetAugs = new AugmentationsImpl();
    private final LocationItem fLocationItem = new LocationItem();
    private final boolean[] fSingleBoolean = new boolean[]{false};
    private final XMLResourceIdentifierImpl fResourceId = new XMLResourceIdentifierImpl();
    static /* synthetic */ Class class$org$apache$xerces$xni$XMLLocator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$xerces$xni$NamespaceContext;
    static /* synthetic */ Class class$org$apache$xerces$xni$Augmentations;

    public void pushInputSource(XMLInputSource xMLInputSource) {
        Reader reader = xMLInputSource.getCharacterStream();
        if (reader == null) {
            throw new IllegalArgumentException("pushed input source has no reader");
        }
        this.fCurrentEntityStack.push(this.fCurrentEntity);
        String string = xMLInputSource.getEncoding();
        String string2 = xMLInputSource.getPublicId();
        String string3 = xMLInputSource.getBaseSystemId();
        String string4 = xMLInputSource.getSystemId();
        String string5 = HTMLScanner.expandSystemId(string4, string3);
        this.fCurrentEntity = new CurrentEntity(reader, string, string2, string3, string4, string5);
    }

    public void cleanup(boolean bl) {
        block9: {
            block8: {
                int n = this.fCurrentEntityStack.size();
                if (n <= 0) break block8;
                if (this.fCurrentEntity != null) {
                    try {
                        this.fCurrentEntity.stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                int n2 = bl ? 0 : 1;
                while (n2 < n) {
                    this.fCurrentEntity = (CurrentEntity)this.fCurrentEntityStack.pop();
                    try {
                        this.fCurrentEntity.stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++n2;
                }
                break block9;
            }
            if (!bl || this.fCurrentEntity == null) break block9;
            try {
                this.fCurrentEntity.stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getEncoding() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.encoding : null;
    }

    public String getPublicId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.publicId : null;
    }

    public String getBaseSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.baseSystemId : null;
    }

    public String getLiteralSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.literalSystemId : null;
    }

    public String getExpandedSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.expandedSystemId : null;
    }

    public int getLineNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.lineNumber : -1;
    }

    public int getColumnNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.columnNumber : -1;
    }

    public Boolean getFeatureDefault(String string) {
        int n = RECOGNIZED_FEATURES != null ? RECOGNIZED_FEATURES.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (RECOGNIZED_FEATURES[n2].equals(string)) {
                return RECOGNIZED_FEATURES_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n = RECOGNIZED_PROPERTIES != null ? RECOGNIZED_PROPERTIES.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (RECOGNIZED_PROPERTIES[n2].equals(string)) {
                return RECOGNIZED_PROPERTIES_DEFAULTS[n2];
            }
            ++n2;
        }
        return null;
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fAugmentations = xMLComponentManager.getFeature(AUGMENTATIONS);
        this.fReportErrors = xMLComponentManager.getFeature(REPORT_ERRORS);
        this.fNotifyCharRefs = xMLComponentManager.getFeature(NOTIFY_CHAR_REFS);
        this.fNotifyXmlBuiltinRefs = xMLComponentManager.getFeature(NOTIFY_XML_BUILTIN_REFS);
        this.fNotifyHtmlBuiltinRefs = xMLComponentManager.getFeature(NOTIFY_HTML_BUILTIN_REFS);
        this.fStripCommentDelims = xMLComponentManager.getFeature(STRIP_COMMENT_DELIMITERS);
        this.fNamesElems = HTMLScanner.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ELEMS)));
        this.fNamesAttrs = HTMLScanner.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ATTRS)));
        this.fDefaultIANAEncoding = String.valueOf(xMLComponentManager.getProperty(DEFAULT_ENCODING));
        this.fErrorReporter = (HTMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (string.equals(AUGMENTATIONS)) {
            this.fAugmentations = bl;
            return;
        }
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals(NAMES_ELEMS)) {
            this.fNamesElems = HTMLScanner.getNamesValue(String.valueOf(object));
            return;
        }
        if (string.equals(NAMES_ATTRS)) {
            this.fNamesAttrs = HTMLScanner.getNamesValue(String.valueOf(object));
            return;
        }
        if (string.equals(DEFAULT_ENCODING)) {
            this.fDefaultIANAEncoding = String.valueOf(object);
            return;
        }
    }

    public void setInputSource(XMLInputSource xMLInputSource) throws IOException {
        this.fElementCount = 0;
        this.fElementDepth = -1;
        this.fByteStream = null;
        this.fCurrentEntityStack.removeAllElements();
        this.fBeginLineNumber = 1;
        this.fBeginColumnNumber = 1;
        this.fEndLineNumber = this.fBeginLineNumber;
        this.fEndColumnNumber = this.fBeginColumnNumber;
        this.fJavaEncoding = this.fIANAEncoding = this.fDefaultIANAEncoding;
        String string = xMLInputSource.getEncoding();
        String string2 = xMLInputSource.getPublicId();
        String string3 = xMLInputSource.getBaseSystemId();
        String string4 = xMLInputSource.getSystemId();
        String string5 = HTMLScanner.expandSystemId(string4, string3);
        Reader reader = xMLInputSource.getCharacterStream();
        if (reader == null) {
            String[] stringArray;
            InputStream inputStream = xMLInputSource.getByteStream();
            if (inputStream == null) {
                stringArray = new URL(string5);
                inputStream = stringArray.openStream();
            }
            this.fByteStream = new PlaybackInputStream(inputStream);
            stringArray = new String[2];
            if (string == null) {
                this.fByteStream.detectEncoding(stringArray);
            } else {
                stringArray[0] = string;
            }
            if (stringArray[0] == null) {
                stringArray[0] = this.fDefaultIANAEncoding;
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML1000", null);
                }
            }
            if (stringArray[1] == null) {
                stringArray[1] = EncodingMap.getIANA2JavaMapping((String)stringArray[0].toUpperCase());
                if (stringArray[1] == null) {
                    stringArray[1] = stringArray[0];
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportWarning("HTML1001", new Object[]{stringArray[0]});
                    }
                }
            }
            this.fIANAEncoding = stringArray[0];
            this.fJavaEncoding = stringArray[1];
            string = this.fIANAEncoding;
            reader = new InputStreamReader((InputStream)this.fByteStream, this.fJavaEncoding);
        }
        this.fCurrentEntity = new CurrentEntity(reader, string, string2, string3, string4, string5);
        this.setScanner(this.fContentScanner);
        this.setScannerState((short)10);
    }

    public boolean scanDocument(boolean bl) throws XNIException, IOException {
        do {
            if (this.fScanner.scan(bl)) continue;
            return false;
        } while (bl);
        return true;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    protected static String getValue(XMLAttributes xMLAttributes, String string) {
        int n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            if (xMLAttributes.getQName(n2).equalsIgnoreCase(string)) {
                return xMLAttributes.getValue(n2);
            }
            ++n2;
        }
        return null;
    }

    public static String expandSystemId(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            object = new URI(string);
            if (object != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        object = HTMLScanner.fixURI(string);
        URI uRI = null;
        URI uRI2 = null;
        try {
            if (string2 == null || string2.length() == 0 || string2.equals(string)) {
                String string3;
                try {
                    string3 = HTMLScanner.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string3 = "";
                }
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                uRI = new URI("file", "", string3, null, null);
            } else {
                try {
                    uRI = new URI(HTMLScanner.fixURI(string2));
                }
                catch (URI.MalformedURIException malformedURIException) {
                    String string4;
                    try {
                        string4 = HTMLScanner.fixURI(System.getProperty("user.dir"));
                    }
                    catch (SecurityException securityException) {
                        string4 = "";
                    }
                    if (string2.indexOf(58) != -1) {
                        uRI = new URI("file", "", HTMLScanner.fixURI(string2), null, null);
                    }
                    if (!string4.endsWith("/")) {
                        string4 = string4 + "/";
                    }
                    string4 = string4 + HTMLScanner.fixURI(string2);
                    uRI = new URI("file", "", string4, null, null);
                }
            }
            uRI2 = new URI(uRI, (String)object);
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        if (uRI2 == null) {
            return string;
        }
        return uRI2.toString();
    }

    protected static String fixURI(String string) {
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2) {
            char c = string.charAt(1);
            if (c == ':') {
                char c2 = Character.toUpperCase(string.charAt(0));
                if (c2 >= 'A' && c2 <= 'Z') {
                    string = "/" + string;
                }
            } else if (c == '/' && string.charAt(0) == '/') {
                string = "file:" + string;
            }
        }
        return string;
    }

    protected static final String modifyName(String string, short s) {
        switch (s) {
            case 1: {
                return string.toUpperCase();
            }
            case 2: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    protected static final short getNamesValue(String string) {
        if (string.equals("lower")) {
            return 2;
        }
        if (string.equals("upper")) {
            return 1;
        }
        return 0;
    }

    protected int read() throws IOException {
        if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) {
            return -1;
        }
        char c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
        ++this.fCurrentEntity.columnNumber;
        return c;
    }

    protected int load(int n) throws IOException {
        int n2 = this.fCurrentEntity.stream.read(this.fCurrentEntity.buffer, n, this.fCurrentEntity.buffer.length - n);
        this.fCurrentEntity.length = n2 != -1 ? n2 + n : n;
        this.fCurrentEntity.offset = n;
        return n2;
    }

    protected void setScanner(Scanner scanner) {
        this.fScanner = scanner;
    }

    protected void setScannerState(short s) {
        this.fScannerState = s;
    }

    protected void scanDoctype() throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.skipSpaces()) {
            string = this.scanName();
            if (string == null) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportError("HTML1014", null);
                }
            } else {
                string = HTMLScanner.modifyName(string, this.fNamesElems);
            }
            if (this.skipSpaces()) {
                if (this.skip("PUBLIC", false)) {
                    this.skipSpaces();
                    string2 = this.scanLiteral();
                    if (this.skipSpaces()) {
                        string3 = this.scanLiteral();
                    }
                } else if (this.skip("SYSTEM", false)) {
                    this.skipSpaces();
                    string3 = this.scanLiteral();
                }
            }
        }
        this.skipMarkup(true);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, null);
        }
    }

    protected String scanLiteral() throws IOException {
        int n = this.read();
        if (n == 39 || n == 34) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.read()) != -1) {
                if (n2 == n) break;
                if (n2 == 13 || n2 == 10) {
                    --this.fCurrentEntity.offset;
                    --this.fCurrentEntity.columnNumber;
                    int n3 = this.skipNewlines();
                    int n4 = 0;
                    while (n4 < n3) {
                        stringBuffer.append('\n');
                        ++n4;
                    }
                    continue;
                }
                stringBuffer.append((char)n2);
            }
            if (n2 == -1) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportError("HTML1007", null);
                }
                throw new EOFException();
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected String scanName() throws IOException {
        int n;
        if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) {
            return null;
        }
        int n2 = this.fCurrentEntity.offset;
        while (true) {
            if (this.fCurrentEntity.offset < this.fCurrentEntity.length) {
                n = this.fCurrentEntity.buffer[this.fCurrentEntity.offset];
                if (Character.isLetterOrDigit((char)n) || n == 45 || n == 46 || n == 58 || n == 95) {
                    ++this.fCurrentEntity.offset;
                    ++this.fCurrentEntity.columnNumber;
                    continue;
                }
            }
            if (this.fCurrentEntity.offset != this.fCurrentEntity.length) break;
            n = this.fCurrentEntity.length - n2;
            System.arraycopy(this.fCurrentEntity.buffer, n2, this.fCurrentEntity.buffer, 0, n);
            int n3 = this.load(n);
            n2 = 0;
            if (n3 == -1) break;
        }
        String string = (n = this.fCurrentEntity.offset - n2) > 0 ? new String(this.fCurrentEntity.buffer, n2, n) : null;
        return string;
    }

    protected int scanEntityRef(XMLStringBuffer xMLStringBuffer, boolean bl) throws IOException {
        xMLStringBuffer.clear();
        xMLStringBuffer.append('&');
        while (true) {
            int n;
            if ((n = this.read()) == 59) break;
            if (!Character.isLetterOrDigit((char)n) && n != 35) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML1004", null);
                }
                --this.fCurrentEntity.offset;
                --this.fCurrentEntity.columnNumber;
                if (bl && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                    this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                    this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                    this.fDocumentHandler.characters((XMLString)xMLStringBuffer, this.locationAugs());
                }
                return -1;
            }
            if (n == -1) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML1004", null);
                }
                if (bl && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                    this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                    this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                    this.fDocumentHandler.characters((XMLString)xMLStringBuffer, this.locationAugs());
                }
                return -1;
            }
            xMLStringBuffer.append((char)n);
        }
        xMLStringBuffer.append(';');
        if (xMLStringBuffer.length == 1) {
            if (bl && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                this.fDocumentHandler.characters((XMLString)xMLStringBuffer, this.locationAugs());
            }
            return -1;
        }
        String string = xMLStringBuffer.toString().substring(1, xMLStringBuffer.length - 1);
        if (string.startsWith("#")) {
            int n;
            block22: {
                n = -1;
                try {
                    n = string.startsWith("#x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
                    if (bl && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                        this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                        this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                        if (this.fNotifyCharRefs) {
                            XMLResourceIdentifier xMLResourceIdentifier = this.resourceId();
                            String string2 = null;
                            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, this.locationAugs());
                        }
                        xMLStringBuffer.clear();
                        xMLStringBuffer.append((char)n);
                        this.fDocumentHandler.characters((XMLString)xMLStringBuffer, this.locationAugs());
                        if (this.fNotifyCharRefs) {
                            this.fDocumentHandler.endGeneralEntity(string, this.locationAugs());
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportError("HTML1005", new Object[]{string});
                    }
                    if (!bl || this.fDocumentHandler == null || this.fElementCount < this.fElementDepth) break block22;
                    this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                    this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                    this.fDocumentHandler.characters((XMLString)xMLStringBuffer, this.locationAugs());
                }
            }
            return n;
        }
        int n = HTMLEntities.get(string);
        if (n == -1) {
            if (this.fReportErrors) {
                this.fErrorReporter.reportWarning("HTML1006", new Object[]{string});
            }
            if (bl && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                this.fDocumentHandler.characters((XMLString)xMLStringBuffer, this.locationAugs());
            }
            return -1;
        }
        if (bl && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
            boolean bl2;
            this.fEndLineNumber = this.fCurrentEntity.lineNumber;
            this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
            boolean bl3 = bl2 = this.fNotifyHtmlBuiltinRefs || this.fNotifyXmlBuiltinRefs && HTMLScanner.builtinXmlRef(string);
            if (bl2) {
                XMLResourceIdentifier xMLResourceIdentifier = this.resourceId();
                String string3 = null;
                this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string3, this.locationAugs());
            }
            xMLStringBuffer.clear();
            xMLStringBuffer.append((char)n);
            this.fDocumentHandler.characters((XMLString)xMLStringBuffer, this.locationAugs());
            if (bl2) {
                this.fDocumentHandler.endGeneralEntity(string, this.locationAugs());
            }
        }
        return n;
    }

    protected boolean skip(String string, boolean bl) throws IOException {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            if (this.fCurrentEntity.offset == this.fCurrentEntity.length) {
                System.arraycopy(this.fCurrentEntity.buffer, this.fCurrentEntity.offset - n2, this.fCurrentEntity.buffer, 0, n2);
                if (this.load(n2) == -1) {
                    this.fCurrentEntity.offset = 0;
                    return false;
                }
            }
            char c = string.charAt(n2);
            char c2 = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
            ++this.fCurrentEntity.columnNumber;
            if (!bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                this.fCurrentEntity.offset -= n2 + 1;
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean skipMarkup(boolean var1_1) throws IOException {
        var2_2 = 1;
        var3_3 = false;
        block0: while (true) {
            if (this.fCurrentEntity.offset != this.fCurrentEntity.length || this.load(0) != -1) ** GOTO lbl28
            break;
lbl-1000:
            // 1 sources

            {
                var4_4 = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
                ++this.fCurrentEntity.columnNumber;
                if (var1_1 && var4_4 == '<') {
                    ++var2_2;
                    continue;
                }
                if (var4_4 == '>') {
                    if (--var2_2 != 0) continue;
                    break block0;
                }
                if (var4_4 == '/') {
                    if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) break block0;
                    var4_4 = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
                    ++this.fCurrentEntity.columnNumber;
                    if (var4_4 == '>') {
                        var3_3 = true;
                        if (--var2_2 != 0) continue;
                        break block0;
                    }
                    --this.fCurrentEntity.offset;
                    --this.fCurrentEntity.columnNumber;
                    continue;
                }
                if (var4_4 != '\r' && var4_4 != '\n') continue;
                this.skipNewlines();
lbl28:
                // 7 sources

                ** while (this.fCurrentEntity.offset < this.fCurrentEntity.length)
            }
lbl29:
            // 1 sources

        }
        return var3_3;
    }

    protected boolean skipSpaces() throws IOException {
        char c;
        boolean bl = false;
        while ((this.fCurrentEntity.offset != this.fCurrentEntity.length || this.load(0) != -1) && Character.isSpace(c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset])) {
            bl = true;
            if (c == '\r' || c == '\n') {
                this.skipNewlines();
                continue;
            }
            ++this.fCurrentEntity.offset;
            ++this.fCurrentEntity.columnNumber;
        }
        return bl;
    }

    protected int skipNewlines() throws IOException {
        if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) {
            return 0;
        }
        char c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset];
        int n = 0;
        int n2 = this.fCurrentEntity.offset;
        if (c == '\n' || c == '\r') {
            do {
                if ((c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++]) == '\r') {
                    ++n;
                    if (this.fCurrentEntity.offset == this.fCurrentEntity.length) {
                        n2 = 0;
                        this.fCurrentEntity.offset = n;
                        if (this.load(n) == -1) break;
                    }
                    if (this.fCurrentEntity.buffer[this.fCurrentEntity.offset] != '\n') continue;
                    ++this.fCurrentEntity.offset;
                    ++n2;
                    continue;
                }
                if (c == '\n') {
                    ++n;
                    if (this.fCurrentEntity.offset != this.fCurrentEntity.length) continue;
                    n2 = 0;
                    this.fCurrentEntity.offset = n;
                    if (this.load(n) != -1) continue;
                    break;
                }
                --this.fCurrentEntity.offset;
                break;
            } while (this.fCurrentEntity.offset < this.fCurrentEntity.length - 1);
            this.fCurrentEntity.lineNumber += n;
            this.fCurrentEntity.columnNumber = 1;
        }
        return n;
    }

    protected final Augmentations locationAugs() {
        Augmentations augmentations = null;
        if (this.fAugmentations) {
            this.fLocationItem.setValues(this.fBeginLineNumber, this.fBeginColumnNumber, this.fEndLineNumber, this.fEndColumnNumber);
            augmentations = this.fInfosetAugs;
            Class<?> clazz = augmentations.getClass();
            Method method = null;
            try {
                method = clazz.getMethod("clear", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("removeAllItems", null);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    augmentations = new AugmentationsImpl();
                }
            }
            if (method != null) {
                try {
                    method.invoke((Object)augmentations, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    augmentations = new AugmentationsImpl();
                }
                catch (InvocationTargetException invocationTargetException) {
                    augmentations = new AugmentationsImpl();
                }
            }
            augmentations.putItem(AUGMENTATIONS, (Object)this.fLocationItem);
        }
        return augmentations;
    }

    protected final XMLResourceIdentifier resourceId() {
        this.fResourceId.clear();
        return this.fResourceId;
    }

    protected static boolean builtinXmlRef(String string) {
        return string.equals("amp") || string.equals("lt") || string.equals("gt") || string.equals("quot") || string.equals("apos");
    }

    private void printBuffer() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class LocationItem
    implements HTMLEventInfo {
        protected int fBeginLineNumber;
        protected int fBeginColumnNumber;
        protected int fEndLineNumber;
        protected int fEndColumnNumber;

        protected LocationItem() {
        }

        public void setValues(int n, int n2, int n3, int n4) {
            this.fBeginLineNumber = n;
            this.fBeginColumnNumber = n2;
            this.fEndLineNumber = n3;
            this.fEndColumnNumber = n4;
        }

        public int getBeginLineNumber() {
            return this.fBeginLineNumber;
        }

        public int getBeginColumnNumber() {
            return this.fBeginColumnNumber;
        }

        public int getEndLineNumber() {
            return this.fEndLineNumber;
        }

        public int getEndColumnNumber() {
            return this.fEndColumnNumber;
        }

        public boolean isSynthesized() {
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fBeginLineNumber);
            stringBuffer.append(':');
            stringBuffer.append(this.fBeginColumnNumber);
            stringBuffer.append(':');
            stringBuffer.append(this.fEndLineNumber);
            stringBuffer.append(':');
            stringBuffer.append(this.fEndColumnNumber);
            return stringBuffer.toString();
        }
    }

    public static class PlaybackInputStream
    extends FilterInputStream {
        private static final boolean DEBUG_PLAYBACK = false;
        protected boolean fPlayback = false;
        protected boolean fCleared = false;
        protected boolean fDetected = false;
        protected byte[] fByteBuffer = new byte[1024];
        protected int fByteOffset = 0;
        protected int fByteLength = 0;
        public int fPushbackOffset = 0;
        public int fPushbackLength = 0;

        public PlaybackInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public void detectEncoding(String[] stringArray) throws IOException {
            if (this.fDetected) {
                throw new IOException("Should not detect encoding twice.");
            }
            this.fDetected = true;
            int n = this.read();
            if (n == -1) {
                return;
            }
            int n2 = this.read();
            if (n2 == -1) {
                this.fPushbackLength = 1;
                return;
            }
            if (n == 239 && n2 == 187) {
                int n3 = this.read();
                if (n3 == 191) {
                    this.fPushbackOffset = 3;
                    stringArray[0] = "UTF-8";
                    stringArray[1] = "UTF8";
                    return;
                }
                this.fPushbackLength = 3;
            }
            if (n == 255 && n2 == 254) {
                stringArray[0] = "UTF-16";
                stringArray[1] = "UnicodeLittleUnmarked";
                return;
            }
            if (n == 254 && n2 == 255) {
                stringArray[0] = "UTF-16";
                stringArray[1] = "UnicodeBigUnmarked";
                return;
            }
            this.fPushbackLength = 2;
        }

        public void playback() {
            this.fPlayback = true;
        }

        public void clear() {
            if (!this.fPlayback) {
                this.fCleared = true;
                this.fByteBuffer = null;
            }
        }

        public int read() throws IOException {
            if (this.fPushbackOffset < this.fPushbackLength) {
                return this.fByteBuffer[this.fPushbackOffset++];
            }
            if (this.fCleared) {
                return this.in.read();
            }
            if (this.fPlayback) {
                byte by = this.fByteBuffer[this.fByteOffset++];
                if (this.fByteOffset == this.fByteLength) {
                    this.fCleared = true;
                    this.fByteBuffer = null;
                }
                return by;
            }
            int n = this.in.read();
            if (n != -1) {
                if (this.fByteLength == this.fByteBuffer.length) {
                    byte[] byArray = new byte[this.fByteLength + 1024];
                    System.arraycopy(this.fByteBuffer, 0, byArray, 0, this.fByteLength);
                    this.fByteBuffer = byArray;
                }
                this.fByteBuffer[this.fByteLength++] = (byte)n;
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.fPushbackOffset < this.fPushbackLength) {
                int n3 = this.fPushbackLength - this.fPushbackOffset;
                if (n3 > n2) {
                    n3 = n2;
                }
                System.arraycopy(this.fByteBuffer, this.fPushbackOffset, byArray, n, n3);
                this.fPushbackOffset += n3;
                return n3;
            }
            if (this.fCleared) {
                return this.in.read(byArray, n, n2);
            }
            if (this.fPlayback) {
                if (this.fByteOffset + n2 > this.fByteLength) {
                    n2 = this.fByteLength - this.fByteOffset;
                }
                System.arraycopy(this.fByteBuffer, this.fByteOffset, byArray, n, n2);
                this.fByteOffset += n2;
                if (this.fByteOffset == this.fByteLength) {
                    this.fCleared = true;
                    this.fByteBuffer = null;
                }
                return n2;
            }
            int n4 = this.in.read(byArray, n, n2);
            if (n4 != -1) {
                if (this.fByteLength + n4 > this.fByteBuffer.length) {
                    byte[] byArray2 = new byte[this.fByteLength + n4 + 512];
                    System.arraycopy(this.fByteBuffer, 0, byArray2, 0, this.fByteLength);
                    this.fByteBuffer = byArray2;
                }
                System.arraycopy(byArray, n, this.fByteBuffer, this.fByteLength, n4);
                this.fByteLength += n4;
            }
            return n4;
        }
    }

    public class SpecialScanner
    implements Scanner {
        protected String fElementName;
        protected boolean fScript;
        protected boolean fTextarea;
        private final QName fQName = new QName();
        private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();

        public Scanner setElementName(String string) {
            this.fElementName = string;
            this.fScript = this.fElementName.equalsIgnoreCase("SCRIPT");
            this.fTextarea = this.fElementName.equalsIgnoreCase("TEXTAREA");
            return this;
        }

        public boolean scan(boolean bl) throws IOException {
            boolean bl2;
            do {
                try {
                    bl2 = false;
                    boolean bl3 = false;
                    switch (HTMLScanner.this.fScannerState) {
                        case 0: {
                            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber--;
                            int n = HTMLScanner.this.read();
                            if (n == 60) {
                                n = HTMLScanner.this.read();
                                if (n == 33 && HTMLScanner.this.read() == 45 && HTMLScanner.this.read() == 45) {
                                    boolean bl4;
                                    this.fStringBuffer.clear();
                                    boolean bl5 = bl4 = this.fScript && HTMLScanner.this.fStripCommentDelims;
                                    if (!bl4) {
                                        this.fStringBuffer.append("<!--");
                                    }
                                    bl3 = true;
                                } else if (n == 47) {
                                    String string = HTMLScanner.this.scanName();
                                    if (string != null) {
                                        if (string.equalsIgnoreCase(this.fElementName)) {
                                            string = HTMLScanner.modifyName(string, HTMLScanner.this.fNamesElems);
                                            HTMLScanner.this.skipMarkup(false);
                                            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                                this.fQName.setValues(null, string, string, null);
                                                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                                                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                                                HTMLScanner.this.fDocumentHandler.endElement(this.fQName, HTMLScanner.this.locationAugs());
                                            }
                                            HTMLScanner.this.setScanner(HTMLScanner.this.fContentScanner);
                                            HTMLScanner.this.setScannerState((short)0);
                                            return true;
                                        }
                                        this.fStringBuffer.clear();
                                        this.fStringBuffer.append("</");
                                        this.fStringBuffer.append(string);
                                    } else {
                                        this.fStringBuffer.clear();
                                        this.fStringBuffer.append("</");
                                    }
                                } else {
                                    this.fStringBuffer.clear();
                                    this.fStringBuffer.append('<');
                                    this.fStringBuffer.append((char)n);
                                }
                            } else if (n == 38) {
                                if (this.fTextarea) {
                                    HTMLScanner.this.scanEntityRef(this.fStringBuffer, true);
                                    break;
                                }
                                this.fStringBuffer.clear();
                                this.fStringBuffer.append('&');
                            } else {
                                if (n == -1) {
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                                    }
                                    throw new EOFException();
                                }
                                --HTMLScanner.this.fCurrentEntity.offset;
                                this.fStringBuffer.clear();
                            }
                            this.scanCharacters(this.fStringBuffer, bl3);
                        }
                    }
                }
                catch (EOFException eOFException) {
                    HTMLScanner.this.setScanner(HTMLScanner.this.fContentScanner);
                    if (HTMLScanner.this.fCurrentEntityStack.empty()) {
                        HTMLScanner.this.setScannerState((short)11);
                    } else {
                        HTMLScanner.this.fCurrentEntity = (CurrentEntity)HTMLScanner.this.fCurrentEntityStack.pop();
                        HTMLScanner.this.setScannerState((short)0);
                    }
                    return true;
                }
            } while (bl2 || bl);
            return true;
        }

        protected void scanCharacters(XMLStringBuffer xMLStringBuffer, boolean bl) throws IOException {
            boolean bl2;
            boolean bl3 = bl2 = this.fScript && HTMLScanner.this.fStripCommentDelims;
            while (true) {
                int n;
                if ((n = HTMLScanner.this.read()) == -1 || !bl && (n == 60 || n == 38)) {
                    if (n == -1) break;
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    break;
                }
                if (n == 13) {
                    HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                    ++HTMLScanner.this.fCurrentEntity.lineNumber;
                    xMLStringBuffer.append('\n');
                    n = HTMLScanner.this.read();
                    if (n == 10) continue;
                    if (n == -1 || !bl && n == 60) {
                        --HTMLScanner.this.fCurrentEntity.offset;
                        --HTMLScanner.this.fCurrentEntity.columnNumber;
                        break;
                    }
                    xMLStringBuffer.append((char)n);
                    continue;
                }
                if (bl && n == 45) {
                    int n2 = 0;
                    do {
                        ++n2;
                    } while ((n = HTMLScanner.this.read()) == 45);
                    int n3 = bl2 && n == 62 ? 2 : 0;
                    while (n3 < n2) {
                        xMLStringBuffer.append('-');
                        ++n3;
                    }
                    if (n == -1 || n2 >= 2 && n == 62) {
                        if (bl2) break;
                        xMLStringBuffer.append((char)n);
                        break;
                    }
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    continue;
                }
                xMLStringBuffer.append((char)n);
                if (n != 10) continue;
                HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                ++HTMLScanner.this.fCurrentEntity.lineNumber;
            }
            if (xMLStringBuffer.length > 0 && HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                HTMLScanner.this.fDocumentHandler.characters((XMLString)xMLStringBuffer, HTMLScanner.this.locationAugs());
            }
        }
    }

    public class ContentScanner
    implements Scanner {
        private final QName fQName = new QName();
        private final XMLAttributesImpl fAttributes = new XMLAttributesImpl();

        public boolean scan(boolean bl) throws IOException {
            boolean bl2;
            do {
                try {
                    bl2 = false;
                    switch (HTMLScanner.this.fScannerState) {
                        case 0: {
                            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber--;
                            int n = HTMLScanner.this.read();
                            if (n == 60) {
                                HTMLScanner.this.setScannerState((short)1);
                                bl2 = true;
                                break;
                            }
                            if (n == 38) {
                                HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBuffer, true);
                                break;
                            }
                            if (n == -1) {
                                throw new EOFException();
                            }
                            --HTMLScanner.this.fCurrentEntity.offset;
                            this.scanCharacters();
                            break;
                        }
                        case 1: {
                            String string;
                            int n = HTMLScanner.this.read();
                            if (n == 33) {
                                if (HTMLScanner.this.skip("DOCTYPE", false)) {
                                    HTMLScanner.this.scanDoctype();
                                } else if (HTMLScanner.this.read() == 45 && HTMLScanner.this.read() == 45) {
                                    this.scanComment();
                                } else {
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1002", null);
                                    }
                                    HTMLScanner.this.skipMarkup(true);
                                }
                            } else if (n == 63) {
                                this.scanPI();
                            } else if (n == 47) {
                                this.scanEndElement();
                            } else {
                                if (n == -1) {
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1003", null);
                                    }
                                    if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                        HTMLScanner.this.fStringBuffer.clear();
                                        HTMLScanner.this.fStringBuffer.append('<');
                                        HTMLScanner.this.fDocumentHandler.characters((XMLString)HTMLScanner.this.fStringBuffer, null);
                                    }
                                    throw new EOFException();
                                }
                                --HTMLScanner.this.fCurrentEntity.offset;
                                --HTMLScanner.this.fCurrentEntity.columnNumber;
                                ++HTMLScanner.this.fElementCount;
                                ((HTMLScanner)HTMLScanner.this).fSingleBoolean[0] = false;
                                string = this.scanStartElement(HTMLScanner.this.fSingleBoolean);
                                if (string != null && !HTMLScanner.this.fSingleBoolean[0] && HTMLElements.getElement(string).isSpecial()) {
                                    HTMLScanner.this.setScanner(HTMLScanner.this.fSpecialScanner.setElementName(string));
                                    HTMLScanner.this.setScannerState((short)0);
                                    return true;
                                }
                            }
                            HTMLScanner.this.setScannerState((short)0);
                            break;
                        }
                        case 10: {
                            String string;
                            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                Object[] objectArray;
                                HTMLScanner hTMLScanner = HTMLScanner.this;
                                string = HTMLScanner.this.fIANAEncoding;
                                NamespaceSupport namespaceSupport = new NamespaceSupport();
                                Augmentations augmentations = HTMLScanner.this.locationAugs();
                                try {
                                    Class<?> clazz = HTMLScanner.this.fDocumentHandler.getClass();
                                    Class[] classArray = new Class[]{class$org$apache$xerces$xni$XMLLocator == null ? HTMLScanner.class$("org.apache.xerces.xni.XMLLocator") : class$org$apache$xerces$xni$XMLLocator, class$java$lang$String == null ? HTMLScanner.class$("java.lang.String") : class$java$lang$String, class$org$apache$xerces$xni$NamespaceContext == null ? HTMLScanner.class$("org.apache.xerces.xni.NamespaceContext") : class$org$apache$xerces$xni$NamespaceContext, class$org$apache$xerces$xni$Augmentations == null ? HTMLScanner.class$("org.apache.xerces.xni.Augmentations") : class$org$apache$xerces$xni$Augmentations};
                                    Method method = clazz.getMethod("startDocument", classArray);
                                    objectArray = new Object[]{hTMLScanner, string, namespaceSupport, augmentations};
                                    method.invoke((Object)HTMLScanner.this.fDocumentHandler, objectArray);
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    throw new XNIException((Exception)illegalAccessException);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    throw new XNIException((Exception)invocationTargetException);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    try {
                                        objectArray = HTMLScanner.this.fDocumentHandler.getClass();
                                        Class[] classArray = new Class[]{class$org$apache$xerces$xni$XMLLocator == null ? HTMLScanner.class$("org.apache.xerces.xni.XMLLocator") : class$org$apache$xerces$xni$XMLLocator, class$java$lang$String == null ? HTMLScanner.class$("java.lang.String") : class$java$lang$String, class$org$apache$xerces$xni$Augmentations == null ? HTMLScanner.class$("org.apache.xerces.xni.Augmentations") : class$org$apache$xerces$xni$Augmentations};
                                        Method method = objectArray.getMethod("startDocument", classArray);
                                        Object[] objectArray2 = new Object[]{hTMLScanner, string, augmentations};
                                        method.invoke((Object)HTMLScanner.this.fDocumentHandler, objectArray2);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        throw new XNIException((Exception)illegalAccessException);
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        throw new XNIException((Exception)invocationTargetException);
                                    }
                                    catch (NoSuchMethodException noSuchMethodException2) {
                                        throw new XNIException((Exception)noSuchMethodException2);
                                    }
                                }
                            }
                            HTMLScanner.this.setScannerState((short)0);
                            break;
                        }
                        case 11: {
                            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                                HTMLScanner.this.fDocumentHandler.endDocument(HTMLScanner.this.locationAugs());
                            }
                            return false;
                        }
                        default: {
                            throw new RuntimeException("unknown scanner state: " + HTMLScanner.this.fScannerState);
                        }
                    }
                }
                catch (EOFException eOFException) {
                    if (HTMLScanner.this.fCurrentEntityStack.empty()) {
                        HTMLScanner.this.setScannerState((short)11);
                    } else {
                        HTMLScanner.this.fCurrentEntity = (CurrentEntity)HTMLScanner.this.fCurrentEntityStack.pop();
                    }
                    bl2 = true;
                }
            } while (bl2 || bl);
            return true;
        }

        protected void scanCharacters() throws IOException {
            int n;
            int n2 = HTMLScanner.this.skipNewlines();
            if (n2 == 0 && HTMLScanner.this.fCurrentEntity.offset == HTMLScanner.this.fCurrentEntity.length) {
                return;
            }
            int n3 = n = HTMLScanner.this.fCurrentEntity.offset - n2;
            while (n3 < HTMLScanner.this.fCurrentEntity.offset) {
                HTMLScanner.this.fCurrentEntity.buffer[n3] = 10;
                ++n3;
            }
            while (HTMLScanner.this.fCurrentEntity.offset < HTMLScanner.this.fCurrentEntity.length) {
                char c = HTMLScanner.this.fCurrentEntity.buffer[HTMLScanner.this.fCurrentEntity.offset];
                if (c == '<' || c == '&' || c == '\n' || c == '\r') break;
                ++HTMLScanner.this.fCurrentEntity.offset;
                ++HTMLScanner.this.fCurrentEntity.columnNumber;
            }
            if (HTMLScanner.this.fCurrentEntity.offset > n && HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fString.setValues(HTMLScanner.this.fCurrentEntity.buffer, n, HTMLScanner.this.fCurrentEntity.offset - n);
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                HTMLScanner.this.fDocumentHandler.characters(HTMLScanner.this.fString, HTMLScanner.this.locationAugs());
            }
        }

        protected void scanComment() throws IOException {
            HTMLScanner.this.fStringBuffer.clear();
            while (true) {
                int n;
                if ((n = HTMLScanner.this.read()) == 45) {
                    int n2;
                    int n3 = 1;
                    while ((n = HTMLScanner.this.read()) == 45) {
                        ++n3;
                    }
                    if (n3 < 2) {
                        HTMLScanner.this.fStringBuffer.append('-');
                        --HTMLScanner.this.fCurrentEntity.offset;
                        --HTMLScanner.this.fCurrentEntity.columnNumber;
                        continue;
                    }
                    if (n != 62) {
                        n2 = 0;
                        while (n2 < n3) {
                            HTMLScanner.this.fStringBuffer.append('-');
                            ++n2;
                        }
                        --HTMLScanner.this.fCurrentEntity.offset;
                        --HTMLScanner.this.fCurrentEntity.columnNumber;
                        continue;
                    }
                    n2 = 0;
                    while (n2 < n3 - 2) {
                        HTMLScanner.this.fStringBuffer.append('-');
                        ++n2;
                    }
                    break;
                }
                if (n == 10 || n == 13) {
                    HTMLScanner.this.skipNewlines();
                } else if (n == -1) {
                    if (HTMLScanner.this.fReportErrors) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    throw new EOFException();
                }
                HTMLScanner.this.fStringBuffer.append((char)n);
            }
            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                HTMLScanner.this.fDocumentHandler.comment((XMLString)HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs());
            }
        }

        protected void scanPI() throws IOException {
            int n;
            String string;
            block7: {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportWarning("HTML1008", null);
                }
                string = HTMLScanner.this.scanName();
                while (true) {
                    if ((n = HTMLScanner.this.read()) == 13 || n == 10) {
                        ++HTMLScanner.this.fCurrentEntity.lineNumber;
                        HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                        if (n != 13 || (n = HTMLScanner.this.read()) == 10) continue;
                        --HTMLScanner.this.fCurrentEntity.offset;
                        continue;
                    }
                    if (n == -1) break block7;
                    if (n != 32 && n != 9) break;
                }
                --HTMLScanner.this.fCurrentEntity.offset;
                --HTMLScanner.this.fCurrentEntity.columnNumber;
            }
            HTMLScanner.this.fStringBuffer.clear();
            while (true) {
                if ((n = HTMLScanner.this.read()) == 63) {
                    n = HTMLScanner.this.read();
                    if (n == 62) break;
                    HTMLScanner.this.fStringBuffer.append('?');
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    continue;
                }
                if (n == 13 || n == 10) {
                    HTMLScanner.this.fStringBuffer.append('\n');
                    ++HTMLScanner.this.fCurrentEntity.lineNumber;
                    HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                    if (n != 13 || (n = HTMLScanner.this.read()) == 10) continue;
                    --HTMLScanner.this.fCurrentEntity.offset;
                    continue;
                }
                if (n == -1) break;
                HTMLScanner.this.fStringBuffer.append((char)n);
            }
            XMLStringBuffer xMLStringBuffer = HTMLScanner.this.fStringBuffer;
            if (HTMLScanner.this.fDocumentHandler != null) {
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                HTMLScanner.this.fDocumentHandler.processingInstruction(string, (XMLString)xMLStringBuffer, HTMLScanner.this.locationAugs());
            }
        }

        protected String scanStartElement(boolean[] blArray) throws IOException {
            int n;
            String string = HTMLScanner.this.scanName();
            int n2 = string != null ? string.length() : 0;
            int n3 = n = n2 > 0 ? (int)string.charAt(0) : -1;
            if (n2 == 0 || (n < 97 || n > 122) && (n < 65 || n > 90)) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1009", null);
                }
                if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    HTMLScanner.this.fStringBuffer.clear();
                    HTMLScanner.this.fStringBuffer.append('<');
                    if (n2 > 0) {
                        HTMLScanner.this.fStringBuffer.append(string);
                    }
                    HTMLScanner.this.fDocumentHandler.characters((XMLString)HTMLScanner.this.fStringBuffer, null);
                }
                return null;
            }
            string = HTMLScanner.modifyName(string, HTMLScanner.this.fNamesElems);
            this.fAttributes.removeAllAttributes();
            boolean bl = false;
            int n4 = HTMLScanner.this.fBeginLineNumber;
            int n5 = HTMLScanner.this.fBeginColumnNumber;
            while (this.scanAttribute(this.fAttributes, blArray)) {
            }
            HTMLScanner.this.fBeginLineNumber = n4;
            HTMLScanner.this.fBeginColumnNumber = n5;
            if (HTMLScanner.this.fByteStream != null && HTMLScanner.this.fElementDepth == -1) {
                if (string.equalsIgnoreCase("META")) {
                    String string2 = HTMLScanner.getValue((XMLAttributes)this.fAttributes, "http-equiv");
                    if (string2 != null && string2.equalsIgnoreCase("content-type")) {
                        int n6;
                        String string3 = HTMLScanner.getValue((XMLAttributes)this.fAttributes, "content");
                        int n7 = n6 = string3 != null ? string3.toLowerCase().indexOf("charset=") : -1;
                        if (n6 != -1) {
                            int n8 = string3.indexOf(59, n6);
                            String string4 = n8 != -1 ? string3.substring(n6 + 8, n8) : string3.substring(n6 + 8);
                            try {
                                String string5 = string4;
                                String string6 = EncodingMap.getIANA2JavaMapping((String)string5);
                                if (string6 == null) {
                                    string6 = string5;
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1001", new Object[]{string5});
                                    }
                                }
                                HTMLScanner.this.fCurrentEntity.stream = new InputStreamReader((InputStream)HTMLScanner.this.fByteStream, string6);
                                HTMLScanner.this.fByteStream.playback();
                                HTMLScanner.this.fElementDepth = HTMLScanner.this.fElementCount;
                                HTMLScanner.this.fElementCount = 0;
                                HTMLScanner.this.fCurrentEntity.length = 0;
                                HTMLScanner.this.fCurrentEntity.offset = 0;
                                HTMLScanner.this.fCurrentEntity.lineNumber = 1;
                                HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                if (HTMLScanner.this.fReportErrors) {
                                    HTMLScanner.this.fErrorReporter.reportError("HTML1010", new Object[]{string4});
                                }
                                HTMLScanner.this.fByteStream.clear();
                            }
                        }
                    }
                } else if (string.equalsIgnoreCase("BODY")) {
                    HTMLScanner.this.fByteStream.clear();
                } else {
                    HTMLElements.Element element = HTMLElements.getElement(string);
                    if (element.parent != null && element.parent.length > 0 && element.parent[0].code == 14) {
                        HTMLScanner.this.fByteStream.clear();
                    }
                }
            }
            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                this.fQName.setValues(null, string, string, null);
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                if (blArray[0]) {
                    HTMLScanner.this.fDocumentHandler.emptyElement(this.fQName, (XMLAttributes)this.fAttributes, HTMLScanner.this.locationAugs());
                } else {
                    HTMLScanner.this.fDocumentHandler.startElement(this.fQName, (XMLAttributes)this.fAttributes, HTMLScanner.this.locationAugs());
                }
            }
            return string;
        }

        protected boolean scanAttribute(XMLAttributesImpl xMLAttributesImpl, boolean[] blArray) throws IOException {
            if (!HTMLScanner.this.skipSpaces() && HTMLScanner.this.fReportErrors) {
                HTMLScanner.this.fErrorReporter.reportError("HTML1013", null);
            }
            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber--;
            int n = HTMLScanner.this.read();
            if (n == -1) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                }
                throw new EOFException();
            }
            if (n == 62) {
                return false;
            }
            --HTMLScanner.this.fCurrentEntity.offset;
            String string = HTMLScanner.this.scanName();
            if (string == null) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1011", null);
                }
                blArray[0] = HTMLScanner.this.skipMarkup(false);
                return false;
            }
            string = HTMLScanner.modifyName(string, HTMLScanner.this.fNamesAttrs);
            HTMLScanner.this.skipSpaces();
            n = HTMLScanner.this.read();
            if (n == -1) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                }
                throw new EOFException();
            }
            if (n == 47 || n == 62) {
                this.fQName.setValues(null, string, string, null);
                xMLAttributesImpl.addAttribute(this.fQName, "CDATA", "");
                xMLAttributesImpl.setSpecified(xMLAttributesImpl.getLength() - 1, true);
                if (HTMLScanner.this.fAugmentations) {
                    this.addLocationItem((XMLAttributes)xMLAttributesImpl, xMLAttributesImpl.getLength() - 1);
                }
                if (n == 47) {
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    blArray[0] = HTMLScanner.this.skipMarkup(false);
                }
                return false;
            }
            if (n == 61) {
                HTMLScanner.this.skipSpaces();
                n = HTMLScanner.this.read();
                if (n == -1) {
                    if (HTMLScanner.this.fReportErrors) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    throw new EOFException();
                }
                if (n == 62) {
                    this.fQName.setValues(null, string, string, null);
                    xMLAttributesImpl.addAttribute(this.fQName, "CDATA", "");
                    xMLAttributesImpl.setSpecified(xMLAttributesImpl.getLength() - 1, true);
                    if (HTMLScanner.this.fAugmentations) {
                        this.addLocationItem((XMLAttributes)xMLAttributesImpl, xMLAttributesImpl.getLength() - 1);
                    }
                    return false;
                }
                HTMLScanner.this.fStringBuffer.clear();
                HTMLScanner.this.fNonNormAttr.clear();
                if (n != 39 && n != 34) {
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    while (true) {
                        if (Character.isSpace((char)(n = HTMLScanner.this.read())) || n == 62) {
                            --HTMLScanner.this.fCurrentEntity.offset;
                            --HTMLScanner.this.fCurrentEntity.columnNumber;
                            break;
                        }
                        if (n == -1) {
                            if (HTMLScanner.this.fReportErrors) {
                                HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                            }
                            throw new EOFException();
                        }
                        if (n == 38) {
                            int n2 = HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBuffer2, false);
                            if (n2 != -1) {
                                HTMLScanner.this.fStringBuffer.append((char)n2);
                            } else {
                                HTMLScanner.this.fStringBuffer.append((XMLString)HTMLScanner.this.fStringBuffer2);
                            }
                            HTMLScanner.this.fNonNormAttr.append((XMLString)HTMLScanner.this.fStringBuffer2);
                            continue;
                        }
                        HTMLScanner.this.fStringBuffer.append((char)n);
                        HTMLScanner.this.fNonNormAttr.append((char)n);
                    }
                    this.fQName.setValues(null, string, string, null);
                    String string2 = HTMLScanner.this.fStringBuffer.toString();
                    xMLAttributesImpl.addAttribute(this.fQName, "CDATA", string2);
                    int n3 = xMLAttributesImpl.getLength() - 1;
                    xMLAttributesImpl.setSpecified(n3, true);
                    xMLAttributesImpl.setNonNormalizedValue(n3, HTMLScanner.this.fNonNormAttr.toString());
                    if (HTMLScanner.this.fAugmentations) {
                        this.addLocationItem((XMLAttributes)xMLAttributesImpl, xMLAttributesImpl.getLength() - 1);
                    }
                    return true;
                }
                char c = (char)n;
                do {
                    if ((n = HTMLScanner.this.read()) == -1) {
                        if (HTMLScanner.this.fReportErrors) {
                            HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                        }
                        throw new EOFException();
                    }
                    if (n == 38) {
                        int n4 = HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBuffer2, false);
                        if (n4 != -1) {
                            HTMLScanner.this.fStringBuffer.append((char)n4);
                        } else {
                            HTMLScanner.this.fStringBuffer.append((XMLString)HTMLScanner.this.fStringBuffer2);
                        }
                        HTMLScanner.this.fNonNormAttr.append((XMLString)HTMLScanner.this.fStringBuffer2);
                        continue;
                    }
                    if (n == 9) {
                        HTMLScanner.this.fStringBuffer.append(' ');
                        HTMLScanner.this.fNonNormAttr.append('\t');
                        continue;
                    }
                    if (n == 13 || n == 10) {
                        ++HTMLScanner.this.fCurrentEntity.lineNumber;
                        HTMLScanner.this.fCurrentEntity.columnNumber = 0;
                        if (n == 13) {
                            n = HTMLScanner.this.read();
                            if (n != 10) {
                                --HTMLScanner.this.fCurrentEntity.offset;
                                --HTMLScanner.this.fCurrentEntity.columnNumber;
                            } else {
                                HTMLScanner.this.fNonNormAttr.append('\r');
                            }
                        }
                        HTMLScanner.this.fStringBuffer.append(' ');
                        HTMLScanner.this.fNonNormAttr.append((char)n);
                        continue;
                    }
                    if (n == c) continue;
                    HTMLScanner.this.fStringBuffer.append((char)n);
                    HTMLScanner.this.fNonNormAttr.append((char)n);
                } while (n != c);
                this.fQName.setValues(null, string, string, null);
                String string3 = HTMLScanner.this.fStringBuffer.toString();
                xMLAttributesImpl.addAttribute(this.fQName, "CDATA", string3);
                int n5 = xMLAttributesImpl.getLength() - 1;
                xMLAttributesImpl.setSpecified(n5, true);
                xMLAttributesImpl.setNonNormalizedValue(n5, HTMLScanner.this.fNonNormAttr.toString());
                if (HTMLScanner.this.fAugmentations) {
                    this.addLocationItem((XMLAttributes)xMLAttributesImpl, xMLAttributesImpl.getLength() - 1);
                }
            } else {
                this.fQName.setValues(null, string, string, null);
                xMLAttributesImpl.addAttribute(this.fQName, "CDATA", "");
                xMLAttributesImpl.setSpecified(xMLAttributesImpl.getLength() - 1, true);
                --HTMLScanner.this.fCurrentEntity.offset;
                --HTMLScanner.this.fCurrentEntity.columnNumber;
                if (HTMLScanner.this.fAugmentations) {
                    this.addLocationItem((XMLAttributes)xMLAttributesImpl, xMLAttributesImpl.getLength() - 1);
                }
            }
            return true;
        }

        protected void addLocationItem(XMLAttributes xMLAttributes, int n) {
            HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
            HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
            LocationItem locationItem = new LocationItem();
            locationItem.setValues(HTMLScanner.this.fBeginLineNumber, HTMLScanner.this.fBeginColumnNumber, HTMLScanner.this.fEndLineNumber, HTMLScanner.this.fEndColumnNumber);
            Augmentations augmentations = xMLAttributes.getAugmentations(n);
            augmentations.putItem(HTMLScanner.AUGMENTATIONS, (Object)locationItem);
        }

        protected void scanEndElement() throws IOException {
            String string = HTMLScanner.this.scanName();
            if (HTMLScanner.this.fReportErrors && string == null) {
                HTMLScanner.this.fErrorReporter.reportError("HTML1012", null);
            }
            HTMLScanner.this.skipMarkup(false);
            if (string != null) {
                string = HTMLScanner.modifyName(string, HTMLScanner.this.fNamesElems);
                if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    this.fQName.setValues(null, string, string, null);
                    HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                    HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                    HTMLScanner.this.fDocumentHandler.endElement(this.fQName, HTMLScanner.this.locationAugs());
                }
            }
        }
    }

    public static class CurrentEntity {
        public Reader stream;
        public String encoding;
        public String publicId;
        public String baseSystemId;
        public String literalSystemId;
        public String expandedSystemId;
        public int lineNumber = 1;
        public int columnNumber = 1;
        public char[] buffer = new char[2048];
        public int offset = 0;
        public int length = 0;

        public CurrentEntity(Reader reader, String string, String string2, String string3, String string4, String string5) {
            this.stream = reader;
            this.encoding = string;
            this.publicId = string2;
            this.baseSystemId = string3;
            this.literalSystemId = string4;
            this.expandedSystemId = string5;
        }
    }

    public static interface Scanner {
        public boolean scan(boolean var1) throws IOException;
    }
}

