/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.Cell;
import jxl.WorkbookSettings;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.NameTable;
import jxl.biff.formula.Parser;
import jxl.biff.formula.StringFormulaParser;
import jxl.biff.formula.TokenFormulaParser;

public class FormulaParser {
    private Parser parser;

    public FormulaParser(byte[] tokens, Cell rt, ExternalSheet es, NameTable nt, WorkbookSettings ws) throws FormulaException {
        if (es.getWorkbookBof() != null && !es.getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.biff8Supported);
        }
        this.parser = new TokenFormulaParser(tokens, rt, es, nt, ws);
    }

    public FormulaParser(String form, ExternalSheet es, NameTable nt, WorkbookSettings ws) {
        this.parser = new StringFormulaParser(form, es, nt, ws);
    }

    public void adjustRelativeCellReferences(int colAdjust, int rowAdjust) {
        this.parser.adjustRelativeCellReferences(colAdjust, rowAdjust);
    }

    public void parse() throws FormulaException {
        this.parser.parse();
    }

    public String getFormula() throws FormulaException {
        return this.parser.getFormula();
    }

    public byte[] getBytes() {
        return this.parser.getBytes();
    }
}

