/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.ThreadAction;

import org.apache.lucene.index.Term;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.Lucene.LuceneActions;



/**
 * Classe utilisant des Threads pour supprimer des documents de l'index.
 * <br/><br/>
 * Class using threads to delete documents from index.
 *
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
public class ThreadDeleteDoc
    extends Thread {

  private String dir = "";
  private String field = "";
  private String content = "";
  private Term term = null;
  private boolean populated = false;
  private boolean populatedWithTerm = false;


  public ThreadDeleteDoc(String dir, String field, String content) {
    this.dir = dir;
    this.field = field;
    this.content = content;
    populated = true;

  }

  public ThreadDeleteDoc(String dir, Term term) {
    this.dir = dir;
    this.term = term;
    boolean populatedWithTerm = true;
  }

  public void run() {
    if (populated == true) {

      try {
        LuceneActions.getSingletonInstance().deleteDoc(dir, field, content);
        try {
          Thread.sleep(1000);
        }
        catch (InterruptedException ex) {
          ex.printStackTrace();
        }

      }
      catch (LiusException e) {
        e.printStackTrace();
      }

    }
    else if (populatedWithTerm == true) {
      System.out.println("Dbut du thread : " + getName());
      try {
        LuceneActions.getSingletonInstance().deleteDoc(dir, term);

      }
      catch (LiusException e) {
        e.printStackTrace();
      }
    }

  }
}