/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.config;



import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.Map;

/**
 * Classe reprsentant le bean LiusConfig
 * <br/><br/>
 * Class representing the LiusConfig bean.
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
public class LiusConfig {

  private String analyzer;
  private String valueCreateIndex;
  private String mergeFactor;
  private String maxMergeDocs;
  private String optimizeValue;
  private boolean optimize;
  private Collection xmlFileFields;
  private HashMap xmlNodesFields;
  private String repPath;
  private String[] stopWord;
  private String stopWordSep;
  private String[] searchFields;
  private Vector displayFields;
  private String queryTermClass;
  private String termFiled;
  private String defaultSearchField;
  private String elemSearch;
  private String[] rangeQueryFileds;
  private Map javaBeans;
  private Collection pdfFields;
  private Collection msWordFields;
  private Collection htmlFields;
  private Collection excelFields;
  private List lsMixteIndexingElements;
  private Collection rtfFields;
  private Collection txtFields;
  private Collection ooFields;
  private Collection pptFields;
  /**
   * Constructeur sans arguments.
   * <br/><br/>
   * Constructor without arguments.
   */
  public LiusConfig() {
  }


  /**
   * Mthode permettant de rcuprer l'analyseur.
   * <br/><br/>
   * Method for getting the analyser.
   */
  public String getAnalyzer() {
    return analyzer;
  }

  /**
   * Mthode permettant d'initialiser l'analyseur.
   * <br/><br/>
   * Method for initializing analyser.
   */
  public void setAnalyzer(String analyzer) {
    this.analyzer = analyzer;
  }

  /**
   * Mthode permettant d'initialiser la  valeur de create Index
   * (true, false, auto).
   * <br/><br/>
   * Method for initializing the value of createIndex (true, false, auto).
   */
  public void setValueCreateIndex(String valueCreateIndex) {
    this.valueCreateIndex = valueCreateIndex;
  }

  /**
   * Mthode permettant de rcuprer la valeur de create index.
   * <br/><br/>
   * Method for getting the value of createIndex.
   */
  public String getCreateIndex() {
    return valueCreateIndex;
  }

  /**
   * Mthode permettent d'initialiser la valeur d'optimize (valeur permettant
   * d'optimiser l'index),
   * <br/><br/>
   * Method for initializing the value of optimize (value for optimizing the index).
   */
  public void setOptimizeValue(String optimizeValue) {
    this.optimizeValue = optimizeValue;
  }

  /**
       * Mthode permettant de rcuprer la valeur pour optimiser l'index (true, false)
   * sous forme de chane de caractres.
   * <br/><br/>
   * Method for getting the value of optimize (true, false) as a string.
   */
  public String getOptimizeValue() {
    return optimizeValue;
  }

  /**
       * Mthode permettant de rcuprer la valeur pour optimiser l'index (true, false)
   * sous forme d'une valeur boolenne.
   * <br/><br/>
   * Method for getting the value of optimize (true, false) as a boolean.
   */
  public boolean getOptimize() {
    if (optimizeValue.equals("true")) {
      optimize = true;
    }
    else
      optimize = false;
    return optimize;
  }

  /**
   * Mthode permettant de rcuprer la valeur de merge factor.
   * <br/><br/>
   * Method for getting the value of merge factor.
   */
  public String getMergeFactor() {
    return mergeFactor;
  }

  /**
   * Mthode permettant d'initiliser la valeur de merge factor.
   * <br/><br/>
   * Method for initializing the value of merge factor.
   */
  public void setMergeFactor(String mergeFactor) {
    this.mergeFactor = mergeFactor;
  }

  /**
   * Mthode permettant de rcuprer la valeur de max merge documents.
   * <br/><br/>
   * Method for getting the value of max merge documents.
   */
  public String getMaxMergeDocs() {
    return maxMergeDocs;
  }

  /**
   * Mthode permettant d'initialiser la valeur de max merge documents.
   * <br/><br/>
   * Method for intializing the value of max merge documents.
   */
  public void setMaxMergeDocs(String maxMergeDocs) {
    this.maxMergeDocs = maxMergeDocs;
  }

  /**
       * Mthode permettant d'initialiser la valeur storeFileInLucenDoc, en lui passant
   * comme paramtres une collection d'objets de type LiusFields
   * <br/><br/>
   * Method for initializing the value of storeFileInLucenDoc, by passing a Collection
   * of LiusFields objects.
   */
  public void setXmlFileFields(Collection xmlFileFields) {
    this.xmlFileFields = xmlFileFields;
  }

  /**
   * Mthode permettant de rcuprer une collection d'objets de type LiusField.
       * Cette collection est construite  partir de l'lment <storeFileInLucenDoc>
   * dans le fichier de configuration.
   * <br/><br/>
   * Method for getting a Collection of LiusField objects. This collection is
       * constructed from the element <storeFileInLucenDoc> in the configuration file.
   */
  public Collection getXmlFileFields() {
    return xmlFileFields;
  }

  /**
   * Mthode permettant d'initialiser la valeur storeEachNodeinLuceneDoc,
   * en lui passant comme paramtres un HashMap dont la cl est une expression XPath
   * permettant de slectionner le noeud  placer dans le document Lucene,
   * et la valeur (HashMap) une collection d'objets de type LiusField.
   * Ce HashMap est construit  partir de l'lment <storeEachNodeinLuceneDoc>
   * dans le fichier de configuration.
   * <br/><br/>
   * Method for initializing the value storeEachNodeinLuceneDoc by passing it
       * an HashMap which key is an XPath expression for selecting the node to place
   * in the Lucene Document and the value (HashMap) is a Collection of LiusField objects.
   * This HashMap is constructed from the element<storeEachNodeinLuceneDoc> in
   * the configuration file.
   *
   */
  public void setXmlNodesFields(HashMap xmlNodesFields) {
    this.xmlNodesFields = xmlNodesFields;
  }

  /**
   * Mthode permettant de rcuprer la valeur StoreEachNodeinLuceneDoc.
   * Elle retourne un HashMap dont la cl est une expression XPath
   * permettant de slectionner le noeud  placer dans le document Lucene,
   * et la valeur (du HashMap) une collection d'objets de type LiusField.
   * <br/><br/>
   * Method for getting the value storeEachNodeinLuceneDoc. Returns an HashMap
   * which key is an XPath expression for selecting the node to place
       * in the Lucene Document and the value (HashMap) is a Collection of LiusField
   * objects.
   */
  public HashMap getXmlNodesFields() {
    return xmlNodesFields;
  }



  /**
   * Mthode permettant de rcuprer la valeur stopWord.
   * <br/><br/>
   * Method for getting the value stopWord.
   */
  public String[] getStopWord() {
    return stopWord;
  }

  /**
   * Mthode permettant d'initialiser la valeur de stopWord.
   * <br/><br/>
   * Method for initializing value stopWord.
   */
  public void setStopWord(String[] stopWord) {
    this.stopWord = stopWord;
  }

  /**
   * Mthode permettant de rcuprer la valeur stopWordSep.
   * <br/><br/>
   * Method for getting the value stopWordSetp.
   */
  public String getStopWordSep() {
    return stopWordSep;
  }

  /**
   * Mthode permettant d'initialiser la valeur de StopWordSep.
   * <br/><br/>
   * Method for initializing the value stopWordSep.
   */
  public void setStopWordSep(String stopWordSep) {
    this.stopWordSep = stopWordSep;
  }

  /**
   * Mthode permettant de rcuprer la valeur champsRecherche.
   * <br/><br/>
   * Method for getting the value searchFields.
   */
  public String[] getSearchFields() {
    return searchFields;
  }

  /**
   * Mthode permettant d'initialiser champsRecherche.
   * <br/><br/>
   * Method for initializing the value searchFields.
   */
  public void setSearchFields(String[] searchFields) {
    this.searchFields = searchFields;
  }

  /**
   * Mthode permettant de rcuprer la valeur champsAfficher
   * <br/><br/>
   * Method for getting the value displayFields.
   */
  public Vector getDisplayFields() {
    return displayFields;
  }

  /**
   * Mthode permettant d'initialiser champsAfficher.
   * <br/><br/>
   * Method for initializing the value displayFields.
   */
  public void setDisplayFields(Vector displayFields) {
    this.displayFields = displayFields;
  }

  //QueryTerm
  /**
   * Mthode permettant de rcuprer la valeur queryTermClass
   * <br/><br/>
   * Method for getting the value queryTermClass.
   */
  public String getQueryTermClass() {
    return queryTermClass;
  }

  /**
   * Mthode permettant d'initialiser queryTermClass
   * <br/><br/>
   * Method for initializing the value queryTermClass.
   */
  public void setQueryTermClass(String queryTermClass) {
    this.queryTermClass = queryTermClass;
  }

  /**
   * Mthode permettant de rcuprer la valeur termFiled
   * <br/><br/>
   * Method for getting the value termFiled.
   */
  public String getTermFiled() {
    return termFiled;
  }

  /**
   * Mthode permettant d'initialiser termFiled
   * <br/><br/>
   * Method for initializing the value termFiled.
   */
  public void setTermFiled(String termFiled) {
    this.termFiled = termFiled;
  }

  //Query parser
  /**
   * Mthode permettant de rcuprer la valeur defaultSearchField
   * <br/><br/>
   * Method for getting the value defaultSearchField.
   */
  public String getDefaultSearchField() {
    return defaultSearchField;
  }

  /**
   * Mthode permettant d'initialiser defaultSearchField
   * <br/><br/>
   * Method for initializing the value defaultSearchField.
   */
  public void setDefaultSearchField(String defaultSearchField) {
    this.defaultSearchField = defaultSearchField;
  }

  /**
   * Mthode permettant d'initialiser elemSearch.
   * <br/><br/>
   * Method for initializing the value elemSearch.
   */
  public void setElemSearch(String elemSearch) {
    this.elemSearch = elemSearch;
  }

  /**
   * Mthode permettant de rcuprer la valeur elemSearch.
   * <br/><br/>
   * Method for getting the value elemSearch.
   */
  public String getElemSearch() {
    return elemSearch;
  }

  //Range Query
  /**
   * Mthode permettant d'initialiser rangeQueryFileds.
   * <br/><br/>
   * Method for initializing the value rangeQueryFileds.
   */
  public void setRangeQueryFileds(String[] rangeQueryFileds) {
    this.rangeQueryFileds = rangeQueryFileds;
  }

  /**
   * Mthode permettant de rcuprer la valeur RangeQueryFileds.
   * <br/><br/>
   * Method for getting the value rangeQueryFileds.
   */
  public String[] getRangeQueryFileds() {
    return rangeQueryFileds;
  }

  /**
   * Mthode permettant d'initialiser les proprits du JavaBean qui vont tre
   * utilises lors l'indexation  partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for itializing the properties of the JavaBean which will be used
   * for indexing from the LiusConfiguration file.
   */
  public void setJavaBeansFields(Map javaBeans) {
    this.javaBeans = javaBeans;
  }

  /**
   * Mthode permettant de rcuprer les proprits du JavaBeans  partir du
   * fichier de configuration de Lius.
   * <br/><br/>
       * Method for getting the properties of the JavaBean from the Lius configuration
   * file.
   */
  public Map getJavaBeansFields() {
    return javaBeans;
  }

  /**
       * Mthode permettant de rcuprer les champs PDF utiliss lors de l'indexation
   *  partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for getting the PDF fields used during indexation from the Lius
   * configuration file.
   */
  public Collection getPdfFields() {
    return pdfFields;
  }

  /**
   * Mthode permettant d'initialiser les champs PDF utiliss lors de l'indexation 
   * partir du fichier de configuration de Lius
   * <br/><br/>
   * Method for initializing the PDF fields used during indexation from Lius
   * configuration file.
   */
  public void setPdfFields(Collection pdfFields) {
    this.pdfFields = pdfFields;
  }

  /**
   * Mthode permettant de rcuprer les champs MS WORD utiliss lors de l'indexation
   *  partir du fichier de configuration de Lius
   * <br/><br/>
   * Method for getting the MS WORD fields used during indexation from the Lius
   * configuration file.
   */
  public Collection getMsWordFields() {
    return msWordFields;
  }

  /**
   * Mthode permettant d'initialiser les champs MS WORD utiliss lors de l'indexation 
   * partir du fichier de configuration de Lius
   * <br/><br/>
       * Method for initializing the MS WORD fields used during indexation from Lius
   * configuration file.
   */
  public void setMsWordFields(Collection msWordFields) {
    this.msWordFields = msWordFields;
  }

  /**
       * Mthode permettant de rcuprer les champs HTML utiliss lors de l'indexation
   *  partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for getting the HTML fields used during indexation from the Lius
   * configuration file.
   */
  public Collection getHtmlFields() {
    return htmlFields;
  }

  /**
   * Mthode permettant d'initialiser les champs HTML utiliss lors de l'indexation 
   * partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for initializing the HTML fields used during indexation from Lius
   * configuration file.
   */
  public void setHtmlFields(Collection htmlFields) {
    this.htmlFields = htmlFields;
  }

  /**
   * Mthode permettant d'initialiser les champs pour l'indexation mixte utiliss lors de l'indexation 
   * partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for initializing the mixed indexation fields used during indexation from Lius
   * configuration file.
   */
  public void setMixteIndexingElements(List lsMixteIndexingElements) {
    this.lsMixteIndexingElements = lsMixteIndexingElements;
  }

  /**
       * Mthode permettant de rcuprer les champs pour l'indexation mixte utiliss
   * lors de l'indexation  partir du fichier de configuration de Lius.
   * <br/><br/>
       * Method for getting the mixed indexation fields used during indexation from the
   * Lius configuration file.
   */
  public List getMixteIndexingElements() {
    return lsMixteIndexingElements;
  }

  /**
   * Mthode permettant de rcuprer les champs pour RTF utiliss
   * lors de l'indexation  partir du fichier de configuration de Lius
   * <br/><br/>
   * Method for getting the RTF fields used during indexation from the
   * Lius configuration file.
   */
  public Collection getRtfFields() {
    return rtfFields;
  }

  /**
   * Mthode permettant d'initialiser les champs RTF utiliss lors de l'indexation 
   * partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for initializing the RTF fields used during indexation from Lius
   * configuration file.
   */
  public void setRtfFields(Collection rtfFields) {
    this.rtfFields = rtfFields;
  }

  /**
   * Mthode permettant de rcuprer les champs pour Excel utiliss
   * lors de l'indexation  partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for getting the Excel fields used during indexation from the
   * Lius configuration file.
   */
  public Collection getExcelFields() {
    return excelFields;
  }

  /**
   * Mthode permettant d'initialiser les champs Excel utiliss lors de l'indexation 
   * partir du fichier de configuration de Lius.
   * <br/><br/>
   * Method for initializing the Excel fields used during indexation from Lius
   * configuration file.
   */
  public void setExcelFields(Collection excelFields) {
    this.excelFields = excelFields;
  }

    public void setTxtFields(Collection txtFields) {
    this.txtFields = txtFields;
  }

  public Collection getTxtFields() {
    return txtFields;
  }

  public void setOOFields(Collection ooFields) {
    this.ooFields = ooFields;
  }

  public Collection getOOFields() {
    return ooFields;
  }

  public void setPPTFields(Collection pptFields) {
    this.pptFields = pptFields;
  }

  public Collection getPPTFields() {
    return pptFields;
  }

}