/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.config;

import java.util.Date;
import java.io.InputStreamReader;
import java.util.Vector;
import java.io.Reader;

/**
 * Classe reprsentant le bean LiusField
 * <br/><br/>
 * Class representing LiusField bean.
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
public class LiusField {

  private String name;
  private String xpathSelect;
  private String type;
  private String value;
  private String ocurSep;
  private String path;
  private long dateLong;
  private Date date;
  private String dateFormat;
  private String getMethod;
  private String get;
  private InputStreamReader valueInputStreamReader;
  private Reader valueReader;
  private String label;
  private Vector values;

  /**
   * Mthode permettant de rcuprer la valeur de name.
   * <br/><br/>
   * Method for getting name value.
   */
  public String getName() {
    return name;
  }

  /** Mthode permettant d'initialiser la  valeur de name.
   * <br/><br/>
   * Method for initializing the name value.
   */
  public void setName(String name) {
    this.name = name;
  }

  /** Mthode permettant de rcuprer la valeur de xpathSelect.
   * <br/><br/>
   * Method for getting xpathSelect value.
   */
  public String getXpathSelect() {
    return xpathSelect;
  }

  /**
   * Mthode permettant d'initialiser la  valeur de xpathSelect.
   * <br/><br/>
   * Method for initializing the xpathSelect value.
   */
  public void setXpathSelect(String xpathSelect) {
    this.xpathSelect = xpathSelect;
  }

  /** Mthode permettant de rcuprer la valeur de type.
   * <br/><br/>
   * Method for getting type value.
   */
  public String getType() {
    return type;
  }

  /** Mthode permettant d'initialiser la  valeur de type.
   * <br/><br/>
   * Method for initializing the type value.
   */
  public void setType(String type) {
    this.type = type;
  }

  /** Mthode permettant de rcuprer la valeur de Value.
   * <br/><br/>
   * Method for getting value value.
   */
  public String getValue() {
    return value;
  }

  /** Mthode permettant d'initialiser la  valeur de value.
   * <br/><br/>
   * Method for initializing the value of value.
   */
  public void setValue(String value) {
    this.value = value;
  }

  /** Mthode permettant de rcuprer la valeur du sparateur d'occurance.
   * <br/><br/>
   * Method for getting the hit separator value.
   */
  public String getOcurSep() {
    return ocurSep;
  }

  /** Mthode permettant d'initialiser la  valeur du sparateur d'occurance.
   * <br/><br/>
   * Method for initializing the hit separator value.
   */
  public void setOcurSep(String ocurSep) {
    this.ocurSep = ocurSep;
  }

  /** Mthode permettant de rcuprer la valeur de path.
   * <br/><br/>
   * Method for getting the path value.
   */
  public String getPath() {
    return path;
  }

  /** Mthode permettant d'initialiser la  valeur de Path.
   * <br/><br/>
   * Method for initializing the path value.
   */
  public void setPath(String path) {
    this.path = path;
  }

  /** Mthode permettant d'initialiser la  valeur de date.
   * <br/><br/>
   * Method for initializing the date value.
   */
  public void setDateLong(long dateLong) {
    this.dateLong = dateLong;
  }

  /** Mthode permettant de rcuprer la valeur de date.
   * <br/><br/>
   * Method for getting the date value.
   */
  public long getDateLong() {
    return dateLong;
  }

  /** Mthode permettant d'initialiser la  valeur de date.
   * <br/><br/>
   * Method for initializing the date value.
   */
  public void setDate(Date date) {
    this.date = date;
  }

  /** Mthode permettant de rcuprer la valeur de date.
   * <br/><br/>
   * Method for getting the date value.
   */
  public Date getDate() {
    return date;
  }

  //nouveau tout ce qui suit
  /**Mthode utilse pour l'indexation du Java Beans.
   *  Elle initialise le nom de la mthode get utilise avec la rflexion en Java pour
   *  rcuprer le contenu du champs*/
  public void setGetMethod(String getMethod) {
    this.getMethod = getMethod;
  }

  /**
   * Permet de rcuperer le nom de la mthode get (utilise pour l'indexation du Java
   * Bean)  partir du fichier de configuration de Lius.
   * <br/><br/>
   * Gets the get method (used for JavaBean indexation) from Lius configuration file.
   */
  public String getGetMethod() {
    return getMethod;
  }

  public void setGet(String get) {
    this.get = get;
  }

  public String getGet() {
    return get;
  }

  /**
   * Utilis pour intialiser le InputStreamReader pour l'indexation du PDF.
   * <br/><br/>
   * Uses for initializing the InputStreamReader for PDF indexation.
   */
  public void setValueInputStreamReader(InputStreamReader
                                        valueInputStreamReader) {
    this.valueInputStreamReader = valueInputStreamReader;
  }

  /**
   * Permet de rcuprer le InputStreamReader utilis pour l'indexation du PDF.
   * <br/><br/>
   * Method for getting the InputStreamReader used for PDF indexation.
   */
  public InputStreamReader getValueInputStreamReader() {
    return valueInputStreamReader;
  }

  /**
   * Utilis pour intialiser le Reader pour l'indexation du HTML.
   * <br/><br/>
   * Used for initializing the Reader for HTML indexation.
   */
  public void setValueReader(Reader valueReader) {
    this.valueReader = valueReader;
  }

  /**
   * Permet de rcuprer le Reader utilis pour l'indexation du HTML.
   * <br/><br/>
   * Method for getting the Reader used for HTML indexation.
   */
  public Reader getValueReader() {
    return valueReader;
  }

  /**
   * Permet d'initialiser le label du rsultat de recherche  partir du
   * fichier de configuration.
   * <br/><br/>
   * Initialize the label of search result from configuration file.
   */
  public void setLabel(String label) {
    this.label = label;
  }

  /**
   * Permet de rcuprer le label du rsultat de recherche  partir du
   * fichier de configuration.
   * <br/><br/>
   * Gets the search result label from configuration file.
   *
   */
  public String getLabel() {
    return label;
  }

  /**
   * Permet de rcuprer les valeurs des occurances multiples d'un champ de
   * rsultat de recherche.
   * <br/><br/>
   * Gets the values of mutiple hits of a search field.
   */
  public Vector getValues() {
    return values;
  }

  /**
   * Permet d'initialiser les valeurs des occurances multiples d'un champ de
   * rsultat de recherche.
   * <br/><br/>
   * Initializes the values of multiple hits of a search result.
   */
  public void setValues(Vector values) {
    this.values = values;
  }

  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public String getDateFormat() {
    return dateFormat;
  }

}