/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.index.PowerPoint;

import ca.ulaval.bibl.lius.index.Indexer;
import org.apache.lucene.document.Document;
import ca.ulaval.bibl.lius.config.LiusConfig;
import java.util.Collection;
import java.io.FileInputStream;
import java.io.*;
import ca.ulaval.bibl.lius.Lucene.LuceneActions;
import java.util.ArrayList;
import java.util.Iterator;
import ca.ulaval.bibl.lius.config.LiusField;
import ca.ulaval.bibl.lius.config.LiusConfigBuilder;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.util.LittleEndian;

/**
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */

public class PPTIndexer
    extends Indexer implements  POIFSReaderListener{
  private ByteArrayOutputStream writer;

  public Object parse(Object file) {
    InputStream input = null;
    try {
      input = new FileInputStream( (String) file);
    }
    catch (FileNotFoundException ex1) {
      ex1.printStackTrace();
    }
    String contents = "";
    try {
        POIFSReader reader = new POIFSReader();
        writer = new ByteArrayOutputStream();
        reader.registerListener(this);
        reader.read(input);
        contents = writer.toString();
    } catch (Exception ex) {
        ex.printStackTrace();
    }

    return contents;

  }

  public Document createLuceneDocument(String file, LiusConfig lc) {
    Document doc = createLuceneDocument(file, lc.getPPTFields());
    return doc;
  }

  public Collection getLiusFields(LiusConfig lc) {
    return lc.getPPTFields();
  }

  public Collection getPopulatedCollection(Object file, Collection liusFields) {
    LuceneActions la = new LuceneActions();
    Collection coll = new ArrayList();
    Iterator it = liusFields.iterator();
    while (it.hasNext()) {
      LiusField lf = (LiusField) it.next();
      if (lf.getGet() != null) {
        if (lf.getGet().equalsIgnoreCase("content")) {
          String content = (String) parse( (String) file);
          lf.setValue(content);
          coll.add(lf);
        }
      }
    }
    return coll;
  }
  public Collection getPopulatedCollection(Object file, String liusConfig) {
   LiusConfig lc = LiusConfigBuilder.getSingletonInstance().getLiusConfig(
       liusConfig);
   return getPopulatedCollection(file, lc);
 }

 public Collection getPopulatedCollection(Object file, LiusConfig lc) {
   return getPopulatedCollection(file, lc.getPPTFields());
 }


public void processPOIFSReaderEvent(POIFSReaderEvent event) {
    try{
        if(!event.getName().equalsIgnoreCase("PowerPoint Document"))
            return;

        DocumentInputStream input = event.getStream();

        byte[] buffer = new byte[input.available()];
        input.read(buffer, 0, input.available());
        for(int i=0; i<buffer.length-20; i++) {
            long type = LittleEndian.getUShort(buffer,i+2);
            long size = LittleEndian.getUInt(buffer,i+4);
            if(type==4008L) {
                writer.write(buffer, i + 4 + 1, (int) size +3);
                i = i + 4 + 1 + (int) size - 1;
            }
        }
    } catch (Exception ex) {
        ex.printStackTrace();
    }
}


}