/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.index.RTF;


import java.io.*;
import javax.swing.text.rtf.RTFEditorKit ;
import javax.swing.text.BadLocationException;
import org.apache.lucene.document.Document;

import ca.ulaval.bibl.lius.Lucene.LuceneActions;
import ca.ulaval.bibl.lius.config.*;
import ca.ulaval.bibl.lius.index.Indexer;

import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;
/**
 * Classe permettant d'indexer des fichiers RTF.
 * <br/><br/>
 * Class that indexes RTF files.
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
public class RTFIndexer extends Indexer{

  public Object parse(Object file){
   String content = "";
   try {
     FileInputStream stream = new FileInputStream((String)file);
     RTFEditorKit kit = new RTFEditorKit();
     javax.swing.text.Document doc = kit.createDefaultDocument();
     kit.read(stream, doc, 0);

     content = doc.getText(0, doc.getLength());

   }
   catch(IOException e){
     e.printStackTrace();
   }
   catch(BadLocationException j){
     j.printStackTrace();
   }

   return content;
 }

  /**
   * Mthode retournant un objet de type Lucene document  partir du fichier 
   * indexer et du fichier de configuration de Lius exprim sous forme d'objet
   * de type LiusConfig.
   * <br/><br/>
   * Method that returns an Lucene Document object from the file to index and
   * the configuration file as a LiusConfig object.
   */
  public Document createLuceneDocument(String file, LiusConfig lc) {
    Document doc = createLuceneDocument(file, lc.getRtfFields());
    return doc;
  }

  /**
   * Retourne une collection contenant les champs avec les valeurs  indexer
   * comme par exemple : le texte integral, titre etc.
   * <br/><br/>
   * Returns a collection containing the fields with the values to index
   * like : full text, title, etc.
   */
  public Collection getPopulatedCollection(Object file, Collection liusFields) {
    LuceneActions la = new LuceneActions();
    Collection coll = new ArrayList();
    Iterator it = liusFields.iterator();
    while (it.hasNext()) {
      LiusField lf = (LiusField) it.next();
      if (lf.getGet() != null) {
        if (lf.getGet().equalsIgnoreCase("content")) {
          String text = (String) parse(file);
          lf.setValue(text);
          coll.add(lf);
        }
      }
    }
    return coll;
  }
  public Collection getPopulatedCollection(Object file, String liusConfig) {
   LiusConfig lc = LiusConfigBuilder.getSingletonInstance().getLiusConfig(
       liusConfig);
   return getPopulatedCollection(file, lc);
 }

 public Collection getPopulatedCollection(Object file, LiusConfig lc) {
   return getPopulatedCollection(file, lc.getRtfFields());
 }

/**
 * Permet de rcuprer les champs de Lius  partir du fichier de configuration
 * pour effectuer l'indexation.
 * <br/><br/>
 * Gets the Lius field from the configuration file for indexation.
 */
  public Collection getLiusFields(LiusConfig lc) {
    return lc.getRtfFields();
  }

}