/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.index.TXT;

import org.apache.lucene.document.Document;

import ca.ulaval.bibl.lius.Lucene.LuceneActions;
import ca.ulaval.bibl.lius.config.LiusConfig;
import ca.ulaval.bibl.lius.config.LiusField;
import ca.ulaval.bibl.lius.index.Indexer;
import java.util.Collection;
import java.io.Reader;
import java.io.FileReader;
import java.io.File;
import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import ca.ulaval.bibl.lius.config.LiusConfigBuilder;

/**
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */

public class TXTIndexer extends Indexer{

  private Object parse(Object file){
    Reader toRead = null;
    try {
      toRead = new FileReader(new File((String)file));
    }
    catch (FileNotFoundException ex) {
      ex.printStackTrace();
    }

    return toRead;
  }

  public Document createLuceneDocument(String file, LiusConfig lc){
     // throws LiusException{
   /* if(lc.getTxtFields().isEmpty())
      throw new LiusException("Problme au niveau de la configuration, revrifier l'lment <txt></txt>");*/
    Document doc = createLuceneDocument(file, lc.getTxtFields());
    return doc;
  }

  public Collection getLiusFields(LiusConfig lc) {
    return lc.getTxtFields();
  }

  public Collection getPopulatedCollection(Object file, Collection liusFields) {
    LuceneActions la = new LuceneActions();
   Collection coll = new ArrayList();
   Iterator it = liusFields.iterator();
   while (it.hasNext()) {
     LiusField lf = (LiusField) it.next();
     if (lf.getGet() != null) {
       if (lf.getGet().equalsIgnoreCase("content")) {
         Reader content =  (Reader)parse((String)file);
         lf.setValueReader(content);
         coll.add(lf);
       }
     }
    }
   return coll;

  }

  public Collection getPopulatedCollection(Object file, String liusConfig) {
   LiusConfig lc = LiusConfigBuilder.getSingletonInstance().getLiusConfig(
       liusConfig);
   return getPopulatedCollection(file, lc);
 }

 public Collection getPopulatedCollection(Object file, LiusConfig lc) {
   return getPopulatedCollection(file, lc.getTxtFields());
 }

}