/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.main.samples;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.document.Document;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.Lucene.AnalyzerFactory;
import ca.ulaval.bibl.lius.Lucene.LuceneActions;
import ca.ulaval.bibl.lius.config.LiusConfig;
import ca.ulaval.bibl.lius.config.LiusConfigBuilder;
import ca.ulaval.bibl.lius.index.Indexer;
import ca.ulaval.bibl.lius.index.IndexerFactory;

import java.io.IOException;

/**
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
public class IndexingFiles {

  public static void main(String[] args) throws IOException {

    String sep = File.separator;
    StringTokenizer st = new StringTokenizer(System.getProperty(
        "java.class.path"), File.pathSeparator);
    File classDir = new File(st.nextToken());
    String indexDir = classDir.getParent() + sep + "luceneIndex";
   // String liusConfig = classDir.getParent() + sep + "Config" + sep + "liusFilesConfig.xml";
       // "liusFilesConfig.xml";
       String liusConfig = "C:\\Tomcat4.1\\webapps\\multiLius\\WEB-INF\\config\\liusConfig.xml";
    String toIndex =  "C:\\Tomcat4.1\\webapps\\multiLius\\WEB-INF\\exemple\\exemple.xml";
        //classDir.getParent() + sep +"LiusOS.sxw";
        //"ExempleFiles" + sep + "meta" + sep + "DublinCore.xml";

//Indexation des fichiers avec Lius (ceci permet d'indexer en utilisant le framework lius)

    LiusConfig lc = LiusConfigBuilder.getSingletonInstance().
        getLiusConfig(liusConfig);

    Analyzer analyzer = AnalyzerFactory.getAnalyzer(lc);
    IndexWriter writer = null;
    try {
      LuceneActions.getSingletonInstance().newIndex(indexDir);
      boolean createIndex = LuceneActions.getSingletonInstance().
          createIndexValue(lc.getCreateIndex(), indexDir);
      writer = new IndexWriter(indexDir, analyzer, createIndex);
      LuceneActions.getSingletonInstance().setIndexWriterProps(writer,lc);
      Indexer indexer = IndexerFactory.getIndexer(toIndex);
      Document luceneDoc = indexer.createLuceneDocument(toIndex, liusConfig);
      LuceneActions.getSingletonInstance().save(luceneDoc, writer, lc);
    }
    catch (IOException e) {
      e.printStackTrace();
    }
    catch (LiusException e) {
      e.printStackTrace();
    }
    finally {
      writer.close();
      LuceneActions.getSingletonInstance().unLock(indexDir);
    }

    /*
     //Il est possible d'indexer en utilisant uniquement cette mthode qui regroupe ce qui est dfinit en haut
     try {
        LuceneActions.getSingletonInstance().index(toIndex, indexDir,
            liusConfig);
      }
      catch (IOException ex) {
        ex.printStackTrace();
      }
      catch (LiusException ex) {
        ex.printStackTrace();
      }
     */

  }

}