/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.main.samples;

import java.util.List;
import java.io.File;
import java.util.StringTokenizer;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.Lucene.AnalyzerFactory;
import ca.ulaval.bibl.lius.Lucene.LuceneActions;
import ca.ulaval.bibl.lius.config.LiusConfig;
import ca.ulaval.bibl.lius.config.LiusConfigBuilder;
import ca.ulaval.bibl.lius.index.XML.XmlNodeIndexer;

/**
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */

public class IndexingXmlNodes {

  public static void main(String[] args) throws IOException {

    String sep = File.separator;
    StringTokenizer st = new StringTokenizer(System.getProperty(
        "java.class.path"), File.pathSeparator);
    File classDir = new File(st.nextToken());
    String indexDir = classDir.getParent() + sep + "luceneIndex";
    String liusConfig = classDir.getParent() + sep + "Config" + sep +
        "liusXmlNodesConfig.xml";

    //test 1
    String toIndex = classDir.getParent() + sep + "ExempleFiles" + sep +
        "node.xml";

    LiusConfig lc = LiusConfigBuilder.getSingletonInstance().
        getLiusConfig(liusConfig);

    Analyzer analyzer = AnalyzerFactory.getAnalyzer(lc);

    IndexWriter writer = null;
    try {
      LuceneActions.getSingletonInstance().deleteAllDocuments(indexDir);
      boolean createIndex = LuceneActions.getSingletonInstance().
          createIndexValue(lc.getCreateIndex(), indexDir);
      writer = new IndexWriter(indexDir, analyzer, createIndex);

      XmlNodeIndexer nodeIndexer = new XmlNodeIndexer();
      List lucenedocsListe = nodeIndexer.createLuceneDocForEachNodeOfDocument(
          toIndex, lc.getXmlNodesFields());
      LuceneActions.getSingletonInstance().save(lucenedocsListe, writer, lc);

    }
    catch (IOException e) {
      e.printStackTrace();
    }
    catch (LiusException e) {
      e.printStackTrace();
    }
    finally {
      writer.close();
      LuceneActions.getSingletonInstance().unLock(indexDir);
    }

  }

}