/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.main.samples;

/**
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */


import java.io.File;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.Lucene.LuceneActions;

import java.io.IOException;
import java.util.StringTokenizer;


public class MixteIndexing {

  public static void main(String[] args) throws IOException, LiusException {

   String sep = File.separator;
   StringTokenizer st = new StringTokenizer(System.getProperty(
       "java.class.path"), File.pathSeparator);

   File classDir = new File(st.nextToken());

   String indexDir = classDir.getParent() + sep + "luceneIndex";

   String liusConfig = classDir.getParent() + sep + "Config" + sep +
       "liusMixteConfig.xml";


   String toIndex = classDir.getParent() + sep + "ExempleFiles" + sep + "dc" + sep + "1";

   try {
      LuceneActions.getSingletonInstance().deleteAllDocuments(indexDir);
      /*La mthode index permet d'indexer aussi bien
      des fichiers que des repertoires contenant diffrents fichiers*/
       LuceneActions.getSingletonInstance().index(toIndex, indexDir,
           liusConfig);
     }
     catch (IOException ex) {
       ex.printStackTrace();
     }
     catch (LiusException ex) {
       ex.printStackTrace();
     }
   }
}