package org.injac.indexing;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ConfInfos {
	static transient Logger logger = Logger.getLogger("INJAC_INDEX");
	public String indexPath;
	public String defaultUrl;
	public String defaultUser;
	public String defaultPassword;
	public String httpsPort;
	public String forceSSL;
	public String debug;
	public String defaultMode;
	public boolean init(ResourceBundle resBundle){
		try{
			indexPath = resBundle.getString("indexPath");	
			defaultUrl = resBundle.getString("defaultUrl");	
			defaultUser = resBundle.getString("defaultUser");
			defaultPassword = resBundle.getString("defaultPassword");
			forceSSL = resBundle.getString("forceSSL");
			httpsPort = resBundle.getString("httpsPort");
			debug = resBundle.getString("debug");
			defaultMode = resBundle.getString("metadata-mode");
			return true;
		}catch(java.util.MissingResourceException mre){
			logger.error("Missing property :"+mre.getMessage());
			return false;
		}
	}
	public int getModeInt(){
		if(defaultMode.equals("all")) return 1;
		if(defaultMode.equals("injac")) return 2;
		return 0;
	}
	
}
