package org.injac.indexing.index;


import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.injac.indexing.Consts;


/**
 * Generic class for indexing
 * Using template and hooks methods from Template design pattern 
 * @author Franois Jannin
 *
 */
public class GenericIndexing {
//	 list of metadatas name for description used to build a reportBean line
	protected String descriptionMD;
	//	 list of metadatas name for title used to build a reportBean line
	protected String titleMD;
	/**
	 *  template method for adding common fields to Lucene Document
	 *  @param srcObject : untyped Object representing source for calling hook methods
	 *  @param luceneDoc : document to add fields to
	 */
	protected void addCommonFields(Object srcObject,Document luceneDoc){
		String title = getTitle(srcObject), desc = getDescription(srcObject);
		if(title==null)
			title="no title";
		if(desc==null)
			desc="no description";
		luceneDoc.add(Field.Text(Consts.INDEX_TITLE, title));
		luceneDoc.add(Field.Text(Consts.INDEX_DESC, desc));
	}
	/**
	 * void hook method - to be implemented in subclasses
	 * @param obj
	 * @return title as String or null
	 */
	protected String getTitle(Object obj) {
		return null;
	}
	
	/**
	 * void hook method - to be implemented in subclasses
	 * @param obj
	 * @return description as String or null
	 */
	protected String getDescription(Object obj) {
		return null;
	}
	
	
}
