/*
 * Created on 23 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.indexing.index.oaipmh;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;


import javax.servlet.ServletException;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.injac.indexing.index.GenericIndexingServlet;

/**
 * Classe permettant de faire l'indexation d'un seul fichier record OAI WebDav
 * Deux modes en fonction des paramtres passs :
 * 1. mode webdav : lit le record via WEBDAV 
 * 		- url
 * 		- user
 * 		- password
 * 2. mode direct : le record est pass en paramtre
 * 		- record
 * Autres paramtres communs aux deux modes :
 * 		- name : nom de l'index utilis
 * 
 * Utilise la session utilisateur pour stocker une instance de ExistIndexing
 * 
 * @author Franois Jannin, ENSEEIHT 2006
 */
public class OAIIndexingServlet extends GenericIndexingServlet {

	private ResourceBundle resBundle;

	public OAIIndexingServlet () {
		super();
		resBundle = ResourceBundle.getBundle("indexation");
	}

	public void service(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, java.io.IOException {

		String url = request.getParameter("url");
		String user = request.getParameter("user");
		String password = request.getParameter("pass");
		String record = request.getParameter("record");
		String indexName = request.getParameter("name");
		String indexPath = resBundle.getString("indexPath");
		String contextPath = getServletContext().getRealPath("/");
		
		boolean fromWebdav = record == null;
		
		HttpSession session = request.getSession();
		response.setContentType("text/html");
		java.io.PrintWriter writer = null;

		File index = new File(indexPath + "/" + indexName);

		if (!index.exists()) {
			response.sendError(201, "Error: index " + indexName
					+ " not created yet ! "
					+ "Please create index first and try again.'");
		} else {
			if(logger.isDebugEnabled()){
				writer = response.getWriter();
				writer.println("<html>");
				writer.println("<head><title>Indexation</title></head>");
				writer.println("<body>");
				logger.debug("Adding " + url + " to index...");
			}
			try {
			/*	
				OAIIndexing existIndexing = (OAIIndexing) session
						.getAttribute("existIndexing");
				if (existIndexing == null) {
					existIndexing = new OAIIndexing(indexName, contextPath+ "WEB-INF"+File.separator+"Config");
					session.setAttribute("existIndexing", existIndexing);
				}
			*/	
				OAIIndexing existIndexing =  new OAIIndexing(indexName, contextPath+ "WEB-INF"+File.separator+"Config");
				boolean result =existIndexing.createTempDirs();
				if(result){
					if(fromWebdav){
						result = existIndexing.index(url, user, password);
					}else{
						result = existIndexing.index(record);
					}
					existIndexing.deleteTempDirs();
					if (logger.isDebugEnabled()) {
						String msg = (result ?
						"File : " + url	+ " added to index or yet indexed."
						: "File : " + url + " not added to index for some reason (see logs)");
						logger.debug(msg);
						writer.println("<p>"+msg+"</p>");	
					}
				}
				
			} catch (Exception he) {
				logger.error(he + " : "+ he.getLocalizedMessage());
				if(logger.isDebugEnabled()){
					writer.println("<p>"+he + " : "+ he.getLocalizedMessage()+"</p>");
				}
			}
		}
		if(logger.isDebugEnabled()){
			writer.println("</body></html>");
			writer.close();
		}else{
			response.setStatus(HttpServletResponse.SC_OK);
			response.flushBuffer();
		}
			
		
	}

	
	
}
