/*
 * Created on 23 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.indexing.index.oaipmh;

import java.io.File;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.injac.indexing.index.GenericIndexingServlet;


import javax.servlet.ServletContext;
/**
 * Classe permettant de faire l'indexation d'une chane record OAI 
 * 
 * mode direct : le record est pass en paramtre
 * 		- record
 * Autres paramtres :
 * 		- name : nom de l'index utilis
 * 
 * Utilise la session utilisateur pour stocker une instance de ExistIndexing
 * 
 * @author Franois Jannin, ENSEEIHT 2006
 */
public class StringOAIIndexingServlet extends GenericIndexingServlet {

	private ResourceBundle resBundle;

	public StringOAIIndexingServlet() {
		super();
		resBundle = ResourceBundle.getBundle("indexation");
	}

	public void service(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, java.io.IOException {

		String record = new String(request.getParameter("record").getBytes(), "UTF-8");
		String indexName = request.getParameter("name");
		String indexPath = resBundle.getString("indexPath");
		String contextPath = getServletContext().getRealPath("/");
		
		
//		HttpSession session = request.getSession(true);
		response.setContentType("text/html");
		java.io.PrintWriter writer = null;

		File index = new File(indexPath + "/" + indexName);

		if (!index.exists()) {
			response.sendError(201, "Error: index " + indexName
					+ " not created yet ! "
					+ "Please create index first and try again.'");
		} else {
			if(logger.isDebugEnabled()){
				writer = response.getWriter();
				writer.println("<html>");
				writer.println("<head><title>Indexation</title></head>");
				writer.println("<body>");
				
			}
			try {
				String url = null;
			
				ServletContext context = getServletContext();
				String client = request.getRemoteAddr();
				StringOAIIndexing existIndexing = (StringOAIIndexing)context.getAttribute(client+"StringOAIIndexing"+indexName);
				if(existIndexing == null){
					existIndexing = new StringOAIIndexing(indexName, contextPath+ "WEB-INF"+File.separator+"Config");
					context.setAttribute(client+"StringOAIIndexing"+indexName,existIndexing );
				}
				 
				boolean 	result = (url =existIndexing.index(record)) != null;
				if (logger.isDebugEnabled()) {
					String msg = "Document : " + url + (result ?
					 " added to index or yet indexed."
					:" not added to index for some reason (see logs)");
					logger.debug(msg);
					writer.println("<p>"+msg+"</p>");	
				}
				
				
			} catch (Exception he) {
				logger.error(he + " : "+ he.getLocalizedMessage());
				if(logger.isDebugEnabled()){
					writer.println("<p>"+he + " : "+ he.getLocalizedMessage()+"</p>");
				}
				else{
					response.setStatus(HttpServletResponse.SC_NOT_MODIFIED);
					response.flushBuffer();
				}
			}
		}
		if(logger.isDebugEnabled()){
			writer.println("</body></html>");
			writer.close();
		}else{
			response.setStatus(HttpServletResponse.SC_OK);
			response.flushBuffer();
		}
			
		
	}

	
	
}
