/*
 * Created on 11 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.indexing.index.webdav;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavFile;
import org.injac.indexing.exceptions.ConnectionException;
import org.injac.indexing.util.BeanPhoenix;
import org.injac.indexing.util.WebdavConnection;
import org.injac.indexing.beans.ReportBean;


/**
 * Classe permetant de parcourir un arbre des repertoires
 * WebDav et qui appele la founction d'indexation 
 * InjacIndexing.index(WebdavFile) pour chaque fichier
 * indexable
 * @author marius
 */
public class UpdateBrowser extends Browser {
	static Logger logger = Logger.getLogger("INJAC_INDEX");
	private ResourceBundle resBundle;
	
	/**
	 * list containg urls of already indexed files
	 */
	
	private ReportBean oldReport;
	public UpdateBrowser(String contextPath, WebdavConnection webdavConnection){
		super(contextPath, webdavConnection);
		resBundle = ResourceBundle.getBundle("indexation");
		
	}
	
	public int indexAll(WebdavFile root, String indexName, int mdMode) throws ConnectionException{
		
		// get last report copy
		getOldReportBean(indexName);
		resetCounts();
		indexing = new InjacIndexing(indexName,contextPath, mdMode, webdavConnection);
		int result = browse(root,indexName,mdMode);
		indexing.closeReport();
		return result;
	}
	
	private boolean getOldReportBean(String indexName){
		String indexPath = resBundle.getString("indexPath");
		String beanReportPath = ReportBean.getPath(indexPath, indexName);
		oldReport = (ReportBean)BeanPhoenix.loadBean(beanReportPath);
		if(oldReport==null){
			logger.error("unable to load report bean : "+beanReportPath);
			return false;
		}
		return true;
	}
	
	private ArrayList extractIndexedFromReport(String indexName){
		String indexPath = resBundle.getString("indexPath");
		String beanReportPath = ReportBean.getPath(indexPath, indexName);
		ReportBean oldReport = (ReportBean)BeanPhoenix.loadBean(beanReportPath);
		
		ArrayList result = new ArrayList();
		
		if(oldReport==null){
			logger.error("unable to load report bean : "+beanReportPath);
			return result;
		}else {
			for(int i=0; i< oldReport.getSize();i++){
				result.add(oldReport.getLine(i).getUrl());
			}
		}
		return result;
	}
	/**
	 * Main function to browse the tree (recursive)
	 * @param root
	 * @throws ConnectionException
	 */
	
	public int browse(WebdavFile root, String indexName, int mdMode) throws ConnectionException{
		try{
			if(!root.exists()){
				throw new ConnectionException();
			}
		}
		catch(org.apache.webdav.lib.WebdavException we){
			throw new ConnectionException();
		}
			
		String[] continut = root.list();
		for(int i=0; i<continut.length; i++){
			String url = continut[i];
			logger.debug(url);
			try{
				
				HttpURL hrl = new HttpURL(continut[i]);
				hrl.setUserinfo(root.getUser(),	root.getPass());
				WebdavFile wf = new WebdavFile(hrl);
				if(wf.isDirectory()){
					browse(wf, indexName, mdMode);
					incDirectoryCount();
				}
				 // filter already indexed files
				else {
					ReportBean.ReportLine line = isAlreadyIndexed(url);
					if(line == null){
						if(indexing.index(wf,indexName)){
							incFileCount();
						}
					}else{
						//TODO  update depending on last modification date from metadatas
						
						// make report anyway
						indexing.reportAlready(line);
					}
				}
				
			}
			catch(HttpException he)
	        {
	        	logger.error("HttpException : "+he.getLocalizedMessage());
	        }
	        catch(IOException ioe)
	        {
	        	logger.error("IOException : "+ioe.getLocalizedMessage());
	        } 
	        
		}
		return FileCount;
	}
	/**
	 * Check existence of a report line for this url
	 * @param url
	 * @return ReportLine object if found in old report, else return NULL
	 */
	private ReportBean.ReportLine isAlreadyIndexed(String url){
		if(oldReport==null)
			return null;
		ReportBean.ReportLine line = null;
		for(int i=0; i< oldReport.getSize();i++){
			line= oldReport.getLine(i);
			String yetURL = line.getUrl();
			if(yetURL.equals(url)){
				return line;
			}
		}
		return null;
	}
	
}
