/**
 * 
 */
package org.injac.indexing.util;


import java.util.HashMap;
import org.apache.webdav.lib.WebdavFile;
import org.injac.indexing.Consts;
import org.injac.indexing.exceptions.ExtractMetadataException;

/**
 * @author Francois Jannin
 * extracting metadatas enumerated by document-injac-metadata
 *  plus modificationdate for update managing
 */
public class InjacMetadataExtract extends MetadataExtract {
	
	/**
	 * 
	 */
	public InjacMetadataExtract(WebdavConnection webdavConnection) {
		super(webdavConnection);
		
	}
	// filter metadatas from space configuration
	public HashMap getMetadata(WebdavFile webdavFile) throws ExtractMetadataException{
		HashMap allMD = super.getMetadata(webdavFile);
		HashMap result = new HashMap();
		// 1. make a doc from parent space metadata property
		String metas = getSpaceMetadatas(webdavFile);
		if(metas!=null){
			ParseRequiredMetaData parser = new ParseRequiredMetaData(metas);
			java.util.ArrayList required = parser.getMetadataList();
			String name = null;
			String value = null;
			for(int i=0; i<required.size();i++){
				RequiredMetaData reqMD = (RequiredMetaData)required.get(i);
				name =reqMD.getName();
				value = (String)allMD.get(name);
				if(value!=null){
					result.put(name, value);
				}
			}
			// adding root-file-name for further processing
			name = "root-file-name";
			value = (String)allMD.get(name);
			result.put(name, value);
			name = "document-state";
			value = (String)allMD.get(name);
			result.put(name, value);
			name = MD_LASTMODIFIED;
			value = (String)allMD.get(name);
			result.put(name, value);
			// namespace for metas format
			name=Consts.INDEX_NAMESPACE;
			value = parser.getNamespace();
			if(value==null){
				value=Consts.NONAMESPACE;
			}
			result.put(name, value);
			
		}else{
			logger.error("no metas MD found for "+webdavFile.getPath());
			return allMD;
		}
		return result;
	}
	
	
}
