/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.io.UnsupportedEncodingException;
import jxl.WorkbookSettings;

public class StringHelper {
    public static byte[] getBytes(String s) {
        return s.getBytes();
    }

    public static byte[] getUnicodeBytes(String s) {
        try {
            byte[] b = s.getBytes("UnicodeLittle");
            if (b.length == s.length() * 2 + 2) {
                byte[] b2 = new byte[b.length - 2];
                System.arraycopy(b, 2, b2, 0, b2.length);
                b = b2;
            }
            return b;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static void getBytes(String s, byte[] d, int pos) {
        byte[] b = StringHelper.getBytes(s);
        System.arraycopy(b, 0, d, pos, b.length);
    }

    public static void getUnicodeBytes(String s, byte[] d, int pos) {
        byte[] b = StringHelper.getUnicodeBytes(s);
        System.arraycopy(b, 0, d, pos, b.length);
    }

    public static String getString(byte[] d, int length, int pos, WorkbookSettings ws) {
        try {
            byte[] b = new byte[length];
            System.arraycopy(d, pos, b, 0, length);
            return new String(b, ws.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            if (!ws.getSuppressWarnings()) {
                System.err.println("Warning:  " + e.toString());
            }
            return "";
        }
    }

    public static String getUnicodeString(byte[] d, int length, int pos) {
        try {
            byte[] b = new byte[length * 2];
            System.arraycopy(d, pos, b, 0, length * 2);
            return new String(b, "UnicodeLittle");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

