/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;

public class PDDocumentCatalog {
    private COSDictionary root;
    private PDDocument document;
    private PDAcroForm acroForm = null;

    public PDDocumentCatalog(PDDocument doc) {
        this.document = doc;
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, (COSBase)new COSString("Catalog"));
        this.document.getDocument().getTrailer().setItem(COSName.ROOT, (COSBase)this.root);
    }

    public PDDocumentCatalog(PDDocument doc, COSDictionary rootDictionary) {
        this.document = doc;
        this.root = rootDictionary;
    }

    public PDAcroForm getAcroForm() {
        if (this.acroForm == null) {
            COSDictionary acroFormDic = (COSDictionary)this.root.getDictionaryObject(COSName.ACRO_FORM);
            if (acroFormDic == null) {
                this.acroForm = new PDAcroForm(this.document);
                this.root.setItem(COSName.ACRO_FORM, (COSBase)this.acroForm.getDictionary());
            } else {
                this.acroForm = new PDAcroForm(this.document, acroFormDic);
            }
        }
        return this.acroForm;
    }

    public PDPageNode getPages() {
        return new PDPageNode((COSDictionary)this.root.getDictionaryObject(COSName.PAGES));
    }

    public List getAllPages() {
        ArrayList retval = new ArrayList();
        PDPageNode rootNode = this.getPages();
        rootNode.getAllKids(retval);
        return retval;
    }

    public PDViewerPreferences getViewerPreferences() {
        PDViewerPreferences retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject("ViewerPreferences");
        if (dict != null) {
            retval = new PDViewerPreferences(dict);
        }
        return retval;
    }

    public void setViewerPreferences(PDViewerPreferences prefs) {
        this.root.setItem("ViewerPreferences", (COSObjectable)prefs);
    }

    public PDDocumentOutline getDocumentOutline() {
        PDDocumentOutline retval = null;
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject("Outlines");
        if (dict != null) {
            retval = new PDDocumentOutline(dict);
        }
        return retval;
    }

    public void setDocumentOutline(PDDocumentOutline outlines) {
        this.root.setItem("Outlines", (COSObjectable)outlines);
    }
}

