/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.filters;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.Identity;

public class Writer
extends DefaultFilter {
    public static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    public static final String NOTIFY_HTML_BUILTIN_REFS = "http://cyberneko.org/html/features/scanner/notify-builtin-refs";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    protected String fEncoding;
    protected PrintWriter fPrinter;
    protected boolean fSeenRootElement;
    protected boolean fSeenHttpEquiv;
    protected int fElementDepth;
    protected boolean fNormalize;
    protected boolean fPrintChars;
    static /* synthetic */ Class class$org$cyberneko$html$filters$Writer;

    public Writer() {
        try {
            this.fEncoding = "UTF-8";
            this.fPrinter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, this.fEncoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public Writer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outputStream, string), string);
    }

    public Writer(java.io.Writer writer, String string) {
        this.fEncoding = string;
        this.fPrinter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = false;
        this.fSeenHttpEquiv = false;
        this.fElementDepth = 0;
        this.fNormalize = true;
        this.fPrintChars = true;
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.startDocument(xMLLocator, string, null, augmentations);
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElement && this.fElementDepth <= 0) {
            this.fPrinter.println();
        }
        this.fPrinter.print("<!--");
        this.printCharacters(xMLString, false);
        this.fPrinter.print("-->");
        if (!this.fSeenRootElement) {
            this.fPrinter.println();
        }
        this.fPrinter.flush();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fNormalize = !HTMLElements.getElement(qName.rawname).isSpecial();
        this.printStartElement(qName, xMLAttributes);
        super.startElement(qName, xMLAttributes, augmentations);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        this.printStartElement(qName, xMLAttributes);
        super.emptyElement(qName, xMLAttributes, augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fPrintChars) {
            this.printCharacters(xMLString, this.fNormalize);
        }
        super.characters(xMLString, augmentations);
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        --this.fElementDepth;
        this.fNormalize = true;
        this.printEndElement(qName);
        super.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.fPrintChars = false;
        this.printEntity(string);
        super.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        this.fPrintChars = true;
        super.endGeneralEntity(string, augmentations);
    }

    protected void printAttributeValue(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"') {
                this.fPrinter.print("&quot;");
            } else {
                this.fPrinter.print(c);
            }
            ++n2;
        }
        this.fPrinter.flush();
    }

    protected void printCharacters(XMLString xMLString, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < xMLString.length) {
                char c = xMLString.ch[xMLString.offset + n];
                if (c != '\n') {
                    String string = Writer.entity(c);
                    if (string != null) {
                        this.printEntity(string);
                    } else {
                        this.fPrinter.print(c);
                    }
                } else {
                    this.fPrinter.println();
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < xMLString.length) {
                char c = xMLString.ch[xMLString.offset + n];
                this.fPrinter.print(c);
                ++n;
            }
        }
        this.fPrinter.flush();
    }

    protected void printStartElement(QName qName, XMLAttributes xMLAttributes) {
        String string;
        int n;
        int n2 = -1;
        String string2 = null;
        if (qName.rawname.toLowerCase().equals("meta")) {
            String string3 = null;
            n = xMLAttributes.getLength();
            int n3 = 0;
            while (n3 < n) {
                string = xMLAttributes.getQName(n3).toLowerCase();
                if (string.equals("http-equiv")) {
                    string3 = xMLAttributes.getValue(n3);
                } else if (string.equals("content")) {
                    n2 = n3;
                }
                ++n3;
            }
            if (string3 != null && string3.toLowerCase().equals("content-type")) {
                this.fSeenHttpEquiv = true;
                string = null;
                if (n2 != -1) {
                    string2 = xMLAttributes.getValue(n2);
                    string = string2.toLowerCase();
                }
                if (string != null) {
                    int n4 = string.indexOf("charset=");
                    string = n4 != -1 ? string.substring(0, n4 + 8) : string + ";charset=";
                    string = string + this.fEncoding;
                    xMLAttributes.setValue(n2, string);
                }
            }
        }
        this.fPrinter.print('<');
        this.fPrinter.print(qName.rawname);
        int n5 = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        n = 0;
        while (n < n5) {
            String string4 = xMLAttributes.getQName(n);
            string = xMLAttributes.getValue(n);
            this.fPrinter.print(' ');
            this.fPrinter.print(string4);
            this.fPrinter.print("=\"");
            this.printAttributeValue(string);
            this.fPrinter.print('\"');
            ++n;
        }
        this.fPrinter.print('>');
        this.fPrinter.flush();
        if (n2 != -1) {
            xMLAttributes.setValue(n2, string2);
        }
    }

    protected void printEndElement(QName qName) {
        this.fPrinter.print("</");
        this.fPrinter.print(qName.rawname);
        this.fPrinter.print('>');
        this.fPrinter.flush();
    }

    protected void printEntity(String string) {
        this.fPrinter.print('&');
        this.fPrinter.print(string);
        this.fPrinter.print(';');
        this.fPrinter.flush();
    }

    private static String entity(char c) {
        switch (c) {
            case '&': {
                return "amp";
            }
            case '<': {
                return "lt";
            }
            case '\u00a0': {
                return "nbsp";
            }
            case '\u00a9': {
                return "copy";
            }
            case '\u00ae': {
                return "reg";
            }
            case '\u2014': {
                return "mdash";
            }
            case '\u00a7': {
                return "sect";
            }
            case '\u00b7': {
                return "middot";
            }
            case '\u00e9': {
                return "eacute";
            }
            case '>': {
                return "gt";
            }
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        HTMLConfiguration hTMLConfiguration = new HTMLConfiguration();
        hTMLConfiguration.setFeature(NOTIFY_CHAR_REFS, true);
        hTMLConfiguration.setFeature(NOTIFY_HTML_BUILTIN_REFS, true);
        String string = "Windows-1252";
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.equals("-e")) {
                string = stringArray[++n];
            } else if (string2.equals("-i")) {
                bl = true;
            } else {
                XMLDocumentFilter[] xMLDocumentFilterArray;
                if (string2.equals("-h")) {
                    Writer.printUsage();
                    System.exit(1);
                }
                if (bl) {
                    hTMLConfiguration.setFeature(AUGMENTATIONS, true);
                    xMLDocumentFilterArray = new XMLDocumentFilter[]{new Identity(), new Writer(System.out, string)};
                } else {
                    xMLDocumentFilterArray = new XMLDocumentFilter[]{new Writer(System.out, string)};
                }
                hTMLConfiguration.setProperty(FILTERS, xMLDocumentFilterArray);
                hTMLConfiguration.parse(new XMLInputSource(null, string2, null));
            }
            ++n;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java " + (class$org$cyberneko$html$filters$Writer == null ? (class$org$cyberneko$html$filters$Writer = Writer.class$("org.cyberneko.html.filters.Writer")) : class$org$cyberneko$html$filters$Writer).getName() + " (options) file ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -e name  Specify IANA name of output encoding.");
        System.err.println("  -i       Perform identity transform.");
        System.err.println("  -h       Display help screen.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

