package org.injac.indexing.beans;
import java.util.*;
import java.io.Serializable;
public class IndexListBean implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 5020636330537160972L;
	private Vector list;
	// Void Constructor
	public IndexListBean(){
		super();
		list=new Vector();
		
	}
	/**
	 * Put a new index description into the bean
	 * @param name
	 * @param webdavUrl
	 * @param login
	 * @param password
	 * @return index of new index if success, -1 if name is redundant.
	 */
	public int addIndex(String name,String webdavUrl,String login, String password, int mode){
		boolean check=true;
		int s = list.size();
		// check name redundancy
		for(int i=0;i<s;i++){
			if( name.equals(getName(i)) ){
				check=false;
			}
		}
		if(check){
			Date date = new Date();
			
			Index newIndex = new Index();
			newIndex.Name=name;
			newIndex.Url = webdavUrl;
			newIndex.Login=login;
			newIndex.Password = password;
			newIndex.Mode = mode;
			newIndex.creationDate = date.getTime();
			newIndex.modificationDate = date.getTime();
			list.add(s, newIndex );
			return s;
		}else
			return -1;
	}
	/**
	 * Remove an index from list
	 * @param index
	 * @return index 0 if existing, -1 otherwise
	 */
	public int removeIndex(int index){
		list.remove(index);
		return (list.size() > 0 ? 0 : -1);
	}
	
	public String getName(int index){
		Index I = getIndex(index);
		if(I ==null)
			return "invalid index";
		return 	I.Name; 
	}
	public String getURL(int index){
		return ((Index)list.get(index)).Url;
	}
	public String getLogin(int index){
		return ((Index)list.get(index)).Login;
	}
	public String getPassword(int index){
		return ((Index)list.get(index)).Password;
	}
	public int getMode(int index){
		return ((Index)list.get(index)).Mode;
	}
	public String getStringMode(int index){
		switch(getMode(index)){
		case 0:
			return "aucune m&eacute;tadonn&eacute;e";
		case 1:
			return "toutes les m&eacute;tadonn&eacute;es inJAC";
		case 2:
			return "les m&eacute;tadonn&eacute;es inJAC de l'espace racine";
		default : 
			return "";
		}
	}
	public long getCreationDate(int index){
		return ((Index)list.get(index)).creationDate;
	}
	public long getModificationDate(int index){
		return ((Index)list.get(index)).modificationDate;
	}
	public void setModificationDate(int index, long time){
		((Index)list.get(index)).modificationDate = time;
	}
	public void updateModificationDate(int index){
		long time = (new Date()).getTime();
		((Index)list.get(index)).modificationDate = time;
	}
	
	public Vector getList() {
		return list;
	}
	public void setList(Vector list) {
		this.list = list;
	}
	
	private Index getIndex(int index){
		try
		{
			Index result =(Index)list.get(index); 
			return result;
		}catch(Exception e){
			return null;
		}
	}
	public int getIndexForName(String indexName){
		boolean check=false;
		int result=-1;
		// check name existance
		for(int i=0;i<list.size();i++){
			if( indexName.equals(getName(i)) ){
				result=i;
				break;
			}
		}
		return result;
	}
}


class Index implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 911591041305037893L;
	int Mode;
	String Name;
	String Url;
	String Login;
	String Password;
	long creationDate, modificationDate;
	public String getLogin() {
		return Login;
	}
	public void setLogin(String login) {
		Login = login;
	}
	public String getName() {
		return Name;
	}
	public void setName(String name) {
		Name = name;
	}
	public String getPassword() {
		return Password;
	}
	public void setPassword(String password) {
		Password = password;
	}
	public int getMode() {
		return Mode;
	}
	public void setMode(int ref) {
		this.Mode = ref;
	}
	public String getUrl() {
		return Url;
	}
	public void setUrl(String url) {
		Url = url;
	}
}