package org.injac.indexing.beans;

import java.io.Serializable;
import java.util.Vector;

import org.injac.indexing.util.BeanPhoenix;

public class ReportBean implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8817190967158060465L;
	private Vector list;
	// Void Constructor
	public ReportBean(){
		super();
		list=new Vector();
	}
	public void addLine(String url, String msg, int duration){
		ReportLine newLine = new ReportLine(url,msg,duration);
		list.add(newLine);
	}
	public void addLine(String url, String msg, int duration, String title, String description, boolean isRoot){
		ReportLine newLine = new ReportLine(url,msg,duration, title, description, isRoot);
		list.add(newLine);
	}
	public Vector getList(){
		return list;
	}
	public ReportLine getLine(int index){
		return (ReportLine)list.get(index);
	}
	public int getSize(){
		return list.size();
	}
	public static String getPath(String indexPath, String indexName){
		return indexPath + "/"+indexName + "/report";
	}
	// classe imbrique
	public class ReportLine implements Serializable {

		/**
		 *  serializable class for report
		 */
		private static final long serialVersionUID = -363649390256089221L;
		String url;
		String msg;
		int duration;
		String title;
		String description;
		boolean isRoot;
		/**
		 * @deprecated
		 * @param url
		 * @param msg
		 * @param duration
		 */
		public ReportLine(String url, String msg, int duration) {
			super();
			this.url = url;
			this.msg = msg;
			this.duration = duration;
		}
		public ReportLine(String url, String msg, int duration, String title, String description, boolean isRoot) {
			super();
			// TODO Auto-generated constructor stub
			this.url = url;
			this.msg = msg;
			this.duration = duration;
			this.title = title;
			this.description = description;
			this.isRoot = isRoot;
		}
		public int getDuration() {
			return duration;
		}
		public void setDuration(int duration) {
			this.duration = duration;
		}
		public String getMsg() {
			return msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public String getUrl() {
			return url;
		}
		public void setUrl(String url) {
			this.url = url;
		}
		public ReportLine(){
			
		}
		
		public String getDescription() {
			return description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public String getTitle() {
			return title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		
		public boolean isRoot() {
			return isRoot;
		}
		public void setRoot(boolean isRoot) {
			this.isRoot = isRoot;
		}
	}
}
